/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.connector.impl;

import com.day.cq.connector.impl.ConnectorAdapter;
import com.day.cq.connector.impl.MetaDataDescriptor;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectorAdapter
implements ConnectorAdapter {
    private final String[] nodeTypes;
    private final MetaDataDescriptor descr;

    public AbstractConnectorAdapter(String[] nodeTypes, MetaDataDescriptor descr) {
        this.nodeTypes = nodeTypes;
        this.descr = descr;
    }

    @Override
    public String[] getSupportedNodeTypes() {
        return this.nodeTypes;
    }

    @Override
    public Calendar getLastModified(Resource resource) {
        if (this.descr.getLastModifiedPath() == null) {
            return null;
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                return node.getProperty(this.descr.getLastModifiedPath()).getDate();
            }
            catch (RepositoryException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getMimeType(Resource resource) {
        if (this.descr.getMimeTypePath() == null) {
            return null;
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node != null) {
            try {
                return node.getProperty(this.descr.getMimeTypePath()).getString();
            }
            catch (RepositoryException e) {
                return null;
            }
        }
        return null;
    }

    protected Iterator<Resource> executeBasicJCRQuery(Resource resource, String fulltext) {
        ResourceResolver resolver = resource.getResourceResolver();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(ISO9075.encodePath((String)resource.getPath()));
        stmt.append("//*[jcr:contains(jcr:content, '");
        stmt.append(fulltext.replaceAll("'", "''"));
        stmt.append("')]");
        return resolver.findResources(stmt.toString(), "xpath");
    }
}

