/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.connector.impl;

import com.day.cq.connector.ConnectorResource;
import com.day.cq.connector.impl.ConnectorAdapter;
import com.day.cq.connector.impl.ConnectorAdapterFactory;
import com.day.cq.connector.impl.ConnectorResourceImpl;
import com.day.cq.connector.impl.NtFileAdapter;
import com.day.cq.connector.impl.NtFolderAdapter;
import com.day.cq.connector.impl.RepRootAdapter;
import com.day.cq.connector.impl.documentum.DctmRootAdapter;
import com.day.cq.connector.impl.sharepoint.SharepointListAdapter;
import com.day.cq.connector.impl.sharepoint.SharepointSiteAdapter;
import com.day.cq.connector.impl.sharepoint.SharepointWebSiteAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorResourceAdapterFactory
implements AdapterFactory,
ConnectorAdapterFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectorResourceAdapterFactory.class);
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<ConnectorResource> CONNECTOR_RESOURCE_CLASS = ConnectorResource.class;
    protected static final String[] ADAPTER_CLASSES = new String[]{CONNECTOR_RESOURCE_CLASS.getName()};
    protected static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_CLASS.getName()};
    private static final Map<String, ConnectorAdapter> CONNECTOR_ADAPTER_CLASSES = new HashMap<String, ConnectorAdapter>();

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Resource res;
        ConnectorAdapter ca;
        if (adaptable instanceof Resource && type == CONNECTOR_RESOURCE_CLASS && (ca = this.getAdapter(res = (Resource)adaptable)) != null) {
            return (AdapterType)new ConnectorResourceImpl(res, ca, this);
        }
        return null;
    }

    @Override
    public ConnectorAdapter getAdapter(Resource resource) {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            return null;
        }
        try {
            String ntName = node.getPrimaryNodeType().getName();
            ConnectorAdapter adapter = CONNECTOR_ADAPTER_CLASSES.get(ntName);
            if (adapter == null) {
                NodeTypeManager ntMgr = node.getSession().getWorkspace().getNodeTypeManager();
                adapter = ConnectorResourceAdapterFactory.resolveAdapter(ntName, ntMgr);
            }
            return adapter;
        }
        catch (RepositoryException e) {
            throw new SlingException("Unable to resolve ConnectorAdapter", (Throwable)e);
        }
    }

    private static void register(Class<? extends ConnectorAdapter> clazz) {
        try {
            ConnectorAdapter adapter = clazz.newInstance();
            for (String nt : adapter.getSupportedNodeTypes()) {
                CONNECTOR_ADAPTER_CLASSES.put(nt, adapter);
            }
        }
        catch (Exception e) {
            log.warn("Exception while registering ConnectorAdapter: " + clazz, (Throwable)e);
        }
    }

    private static ConnectorAdapter resolveAdapter(String ntName, NodeTypeManager ntMgr) throws RepositoryException {
        ConnectorAdapter adapter;
        NodeType[] nts;
        for (NodeType nt : nts = ntMgr.getNodeType(ntName).getDeclaredSupertypes()) {
            ntName = nt.getName();
            adapter = CONNECTOR_ADAPTER_CLASSES.get(ntName);
            if (adapter == null) continue;
            return adapter;
        }
        for (NodeType nt : nts) {
            adapter = ConnectorResourceAdapterFactory.resolveAdapter(nt.getName(), ntMgr);
            if (adapter == null) continue;
            return adapter;
        }
        return null;
    }

    static {
        ConnectorResourceAdapterFactory.register(NtFileAdapter.class);
        ConnectorResourceAdapterFactory.register(NtFolderAdapter.class);
        ConnectorResourceAdapterFactory.register(RepRootAdapter.class);
        ConnectorResourceAdapterFactory.register(SharepointListAdapter.class);
        ConnectorResourceAdapterFactory.register(SharepointSiteAdapter.class);
        ConnectorResourceAdapterFactory.register(SharepointWebSiteAdapter.class);
        ConnectorResourceAdapterFactory.register(DctmRootAdapter.class);
    }
}

