/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.connector.impl;

import com.day.cq.connector.ConnectorResource;
import com.day.cq.connector.impl.ConnectorAdapter;
import com.day.cq.connector.impl.ConnectorAdapterFactory;
import java.util.Calendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorResourceImpl
extends AbstractResource
implements ConnectorResource {
    private final Resource resource;
    private final ConnectorAdapter adapter;
    private final ConnectorAdapterFactory factory;

    public ConnectorResourceImpl(Resource resource, ConnectorAdapter adapter, ConnectorAdapterFactory factory) {
        this.resource = resource;
        this.adapter = adapter;
        this.factory = factory;
    }

    @Override
    public Iterable<ConnectorResource> executeQuery(final String fulltext) {
        return new Iterable<ConnectorResource>(){

            @Override
            public Iterator<ConnectorResource> iterator() {
                return new IteratorHelper(ConnectorResourceImpl.this.adapter.executeQuery(ConnectorResourceImpl.this.resource, fulltext));
            }
        };
    }

    @Override
    public Iterable<ConnectorResource> getChildren() {
        return new Iterable<ConnectorResource>(){

            @Override
            public Iterator<ConnectorResource> iterator() {
                return new IteratorHelper(ConnectorResourceImpl.this.adapter.listChildren(ConnectorResourceImpl.this.resource));
            }
        };
    }

    @Override
    public boolean isContainer() {
        return this.adapter.isContainer(this.resource);
    }

    @Override
    public Calendar getLastModified() {
        return this.adapter.getLastModified(this.resource);
    }

    @Override
    public String getMimeType() {
        return this.adapter.getMimeType(this.resource);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public String getResourceType() {
        return this.resource.getResourceType();
    }

    public String getResourceSuperType() {
        return this.resource.getResourceSuperType();
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resource.getResourceMetadata();
    }

    public ResourceResolver getResourceResolver() {
        return this.resource.getResourceResolver();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> adapterTypeClass) {
        return (AdapterType)this.resource.adaptTo(adapterTypeClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IteratorHelper
    implements Iterator<ConnectorResource> {
        private Iterator<Resource> it;
        private ConnectorResource next;

        public IteratorHelper(Iterator<Resource> resources) {
            this.it = resources;
            this.fetchNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ConnectorResource next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            try {
                ConnectorResource connectorResource = this.next;
                return connectorResource;
            }
            finally {
                this.fetchNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchNext() {
            this.next = null;
            while (this.it.hasNext()) {
                Resource res = this.it.next();
                ConnectorAdapter ca = ConnectorResourceImpl.this.factory.getAdapter(res);
                if (ca == null) continue;
                this.next = new ConnectorResourceImpl(res, ca, ConnectorResourceImpl.this.factory);
                break;
            }
        }
    }
}

