/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.connector.impl;

import com.day.cq.connector.impl.AbstractConnectorAdapter;
import com.day.cq.connector.impl.DefaultMetaDataDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtFolderAdapter
extends AbstractConnectorAdapter {
    private static final Logger log = LoggerFactory.getLogger(NtFolderAdapter.class);

    public NtFolderAdapter() {
        super(new String[]{"nt:folder"}, new DefaultMetaDataDescriptor());
    }

    @Override
    public Iterator<Resource> executeQuery(Resource resource, String fulltext) {
        return this.executeBasicJCRQuery(resource, fulltext);
    }

    @Override
    public Iterator<Resource> listChildren(Resource resource) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        Iterator it = resource.getResourceResolver().listChildren(resource);
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            Node node = (Node)r.adaptTo(Node.class);
            if (node == null) continue;
            try {
                if (!node.isNodeType("nt:hierarchyNode") && !node.isNodeType("rep:root") && !node.isNodeType("dctm:dm_root")) continue;
                children.add(r);
            }
            catch (RepositoryException e) {
                log.warn("Exception checking node type", (Throwable)e);
            }
        }
        return children.iterator();
    }

    @Override
    public boolean isContainer(Resource resource) {
        return true;
    }
}

