/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.connector.impl;

import com.day.cq.connector.impl.AbstractConnectorAdapter;
import com.day.cq.connector.impl.DefaultMetaDataDescriptor;
import com.day.cq.connector.impl.sharepoint.SharepointSiteAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepRootAdapter
extends AbstractConnectorAdapter {
    public RepRootAdapter() {
        super(new String[]{"rep:root"}, new DefaultMetaDataDescriptor());
    }

    @Override
    public Iterator<Resource> executeQuery(Resource resource, String fulltext) {
        ResourceResolver resolver = resource.getResourceResolver();
        Iterator children = resolver.listChildren(resource);
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            if (!Text.getName((String)child.getPath()).equals("sp:Site")) continue;
            return new SharepointSiteAdapter().executeQuery(child, fulltext);
        }
        return this.executeBasicJCRQuery(resource, fulltext);
    }

    @Override
    public Iterator<Resource> listChildren(Resource resource) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        ResourceResolver resolver = resource.getResourceResolver();
        Iterator it = resolver.listChildren(resource);
        while (it.hasNext()) {
            Resource child = (Resource)it.next();
            if (Text.getName((String)child.getPath()).equals("sp:Site")) {
                Iterator<Resource> resources = new SharepointSiteAdapter().listChildren(child);
                while (resources.hasNext()) {
                    children.add(resources.next());
                }
                continue;
            }
            children.add(child);
        }
        return children.iterator();
    }

    @Override
    public boolean isContainer(Resource resource) {
        return true;
    }
}

