/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.connector.impl.sharepoint;

import com.day.cq.connector.impl.AbstractConnectorAdapter;
import com.day.cq.connector.impl.DefaultMetaDataDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSharepointAdapter
extends AbstractConnectorAdapter {
    public AbstractSharepointAdapter(String[] nodeTypes) {
        super(nodeTypes, new DefaultMetaDataDescriptor(){

            public String getLastModifiedPath() {
                return "LastModified";
            }
        });
    }

    @Override
    public Iterator<Resource> executeQuery(Resource resource, String fulltext) {
        ResourceResolver resolver = resource.getResourceResolver();
        StringBuffer stmt = new StringBuffer("/jcr:root");
        stmt.append(ISO9075.encodePath((String)resource.getPath()));
        stmt.append("//*[jcr:contains(., '");
        stmt.append(fulltext.replaceAll("'", "''"));
        stmt.append("')]");
        return resolver.findResources(stmt.toString(), "xpath");
    }

    @Override
    public Iterator<Resource> listChildren(Resource resource) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        ResourceResolver resolver = resource.getResourceResolver();
        ArrayList<Resource> parents = new ArrayList<Resource>();
        parents.add(resource);
        Iterator it = resolver.listChildren(resource);
        while (it.hasNext()) {
            Resource r = (Resource)it.next();
            String name = Text.getName((String)r.getPath());
            if (!name.equals("sp:Lists") && !name.equals("sp:Webs") && !name.equals("sp:Files")) continue;
            parents.add(r);
        }
        for (Resource p : parents) {
            it = resolver.listChildren(p);
            while (it.hasNext()) {
                Resource c = (Resource)it.next();
                Node n = (Node)c.adaptTo(Node.class);
                try {
                    if (n == null || n.getName().startsWith("sp:")) continue;
                    children.add(c);
                }
                catch (RepositoryException e) {}
            }
        }
        return children.iterator();
    }

    @Override
    public boolean isContainer(Resource resource) {
        return true;
    }
}

