/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.ContentSyncManager;
import com.day.cq.contentsync.config.Config;
import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.contentsync.impl.CacheItemCollector;
import com.day.cq.contentsync.impl.config.ConfigUtil;
import com.day.text.Text;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.Credentials;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="Day CQ Content Sync Manager", description="Responsible for cache updates and content delivery using zip files.")
@Service
public class ContentSyncManagerImpl
implements ContentSyncManager {
    private static final Logger log = LoggerFactory.getLogger(ContentSyncManagerImpl.class);
    private static final String ZIPS_SUFFIX = "-zips";
    private static final String DEFAULT_FOLDER_TYPE = "sling:Folder";
    private static final String DEFAULT_FALLBACK_AUTHORIZABLE = "administrators";
    private static final String DEFAULT_FALLBACK_UPDATE_USER = "admin";
    @org.apache.felix.scr.annotations.Property(value={"administrators"})
    private static final String FALLBACK_AUTHORIZABLE = "contentsync.fallback.authorizable";
    @org.apache.felix.scr.annotations.Property(value={"admin"})
    private static final String FALLBACK_UPDATE_USER = "contentsync.fallback.updateuser";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SlingRepository repository;
    private BundleContext bundleContext;
    private String fallbackAuthorizableId;
    private String fallbackUpdateUserId;
    private final Map<Object, ServiceReference> refMap = new HashMap<Object, ServiceReference>();
    private final Map<Object, ComponentInstance> instanceMap = new HashMap<Object, ComponentInstance>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ComponentT> ComponentT getComponent(Class<ComponentT> typeClass, String type) {
        ServiceReference[] refs;
        try {
            refs = this.bundleContext.getServiceReferences(ComponentFactory.class.getName(), "(component.factory=" + typeClass.getName() + '/' + type + ')');
        }
        catch (InvalidSyntaxException e) {
            log.error("Unable to get " + typeClass.getSimpleName() + " instance: " + type, (Throwable)e);
            return null;
        }
        if (refs == null || refs.length == 0) {
            return null;
        }
        ServiceReference ref = refs[0];
        ComponentFactory factory = (ComponentFactory)this.bundleContext.getService(ref);
        ComponentInstance instance = factory.newInstance(null);
        Object component = instance.getInstance();
        if (component == null) {
            log.error("Unable to get " + typeClass.getSimpleName() + " instance: " + type);
            instance.dispose();
            this.bundleContext.ungetService(ref);
        } else {
            ContentSyncManagerImpl contentSyncManagerImpl = this;
            synchronized (contentSyncManagerImpl) {
                this.refMap.put(component, ref);
                this.instanceMap.put(component, instance);
            }
        }
        return (ComponentT)component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseComponent(Object component) {
        ContentSyncManagerImpl contentSyncManagerImpl = this;
        synchronized (contentSyncManagerImpl) {
            if (this.instanceMap.containsKey(component)) {
                this.instanceMap.get(component).dispose();
                this.instanceMap.remove(component);
            }
            if (this.refMap.containsKey(component)) {
                this.bundleContext.ungetService(this.refMap.get(component));
                this.refMap.remove(component);
            }
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        this.bundleContext = context.getBundleContext();
        Dictionary cfg = context.getProperties();
        this.fallbackAuthorizableId = OsgiUtil.toString(cfg.get(FALLBACK_AUTHORIZABLE), (String)FALLBACK_AUTHORIZABLE);
        this.fallbackUpdateUserId = OsgiUtil.toString(cfg.get(FALLBACK_UPDATE_USER), (String)FALLBACK_UPDATE_USER);
    }

    protected void deactivate(ComponentContext context) throws RepositoryException {
        this.bundleContext = null;
    }

    @Override
    public void updateCache(Resource resource, Session session) {
        this.updateCache((Config)resource.adaptTo(Config.class), session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCache(Config config, Session session) {
        block16: {
            Session updateSession;
            block15: {
                block14: {
                    updateSession = null;
                    this.lock.writeLock().lock();
                    boolean changed = false;
                    try {
                        String cachePath = ConfigUtil.configToCachePath(config, session);
                        String configName = ConfigUtil.getConfigName(config, session);
                        if (ConfigUtil.isPersonalized(config.getPath(), session)) {
                            this.setupCache(configName, cachePath, session.getUserID());
                        } else {
                            this.setupCache(configName, cachePath, config.getAuthorizable());
                        }
                        updateSession = this.getCacheUpdateSession(config, session);
                        Long lastUpdated = this.getLatestTimestamp(config, updateSession);
                        Iterator<ConfigEntry> entries = config.getEntries();
                        while (entries.hasNext()) {
                            ConfigEntry entry = entries.next();
                            ContentUpdateHandler handler = this.getComponent(ContentUpdateHandler.class, entry.getType());
                            if (handler != null) {
                                boolean updated = handler.updateCacheEntry(entry, lastUpdated, cachePath, updateSession, updateSession);
                                this.releaseComponent(handler);
                                if (updated) {
                                    changed = true;
                                    log.info("Updating content sync cache due to content change: {}", (Object)entry.getContentPath());
                                    continue;
                                }
                                log.info("Skipping update of content sync cache: {}", (Object)entry.getContentPath());
                                continue;
                            }
                            log.info("No content update handler found for type: {}", (Object)entry.getType());
                        }
                        if (!changed) break block14;
                        this.addCacheTimestamp(config, updateSession);
                        this.cleanupCachedZips(config, updateSession);
                        break block15;
                    }
                    catch (Exception e) {
                        log.error("Unexpected error while updating cache", (Throwable)e);
                        break block16;
                    }
                    finally {
                        if (changed) {
                            this.addCacheTimestamp(config, updateSession);
                            this.cleanupCachedZips(config, updateSession);
                        } else {
                            log.info("No changes detected.");
                        }
                        if (updateSession != null) {
                            updateSession.logout();
                        }
                        this.lock.writeLock().unlock();
                    }
                }
                log.info("No changes detected.");
            }
            if (updateSession != null) {
                updateSession.logout();
            }
            this.lock.writeLock().unlock();
        }
    }

    private Session getCacheUpdateSession(Config config, Session session) throws RepositoryException, LoginException {
        String user = session.getUserID();
        if (!ConfigUtil.isPersonalized(config.getPath(), session)) {
            user = config.getUpdateUser() != null ? config.getUpdateUser() : this.fallbackUpdateUserId;
        }
        SimpleCredentials creds = new SimpleCredentials(user, new char[0]);
        Session admin = this.repository.loginAdministrative(null);
        Session updateSession = admin.impersonate((Credentials)creds);
        admin.logout();
        return updateSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCache(String configName, String cachePath, String authorizableId) throws LoginException, RepositoryException {
        ResourceResolver adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        try {
            JackrabbitSession adminSession = (JackrabbitSession)adminResolver.adaptTo(Session.class);
            JackrabbitAccessControlManager acm = (JackrabbitAccessControlManager)adminSession.getAccessControlManager();
            PrincipalManager pm = adminSession.getPrincipalManager();
            if (!adminSession.nodeExists(cachePath)) {
                String zipsCachePath = cachePath + ZIPS_SUFFIX;
                JcrUtil.createPath((String)cachePath, (String)DEFAULT_FOLDER_TYPE, (Session)adminSession);
                JcrUtil.createPath((String)zipsCachePath, (String)DEFAULT_FOLDER_TYPE, (Session)adminSession);
                if (authorizableId == null) {
                    authorizableId = this.fallbackAuthorizableId;
                }
                Privilege all = acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}all");
                JackrabbitAccessControlList acl = this.getAccessControlList((AccessControlManager)acm, cachePath);
                if (acl != null) {
                    acl.addEntry(pm.getPrincipal(authorizableId), new Privilege[]{all}, true);
                    acm.setPolicy(cachePath, (AccessControlPolicy)acl);
                }
                if ((acl = this.getAccessControlList((AccessControlManager)acm, zipsCachePath)) != null) {
                    acl.addEntry(pm.getPrincipal(authorizableId), new Privilege[]{all}, true);
                    acm.setPolicy(zipsCachePath, (AccessControlPolicy)acl);
                }
                adminSession.save();
            }
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    private JackrabbitAccessControlList getAccessControlList(AccessControlManager acm, String path) throws RepositoryException {
        AccessControlPolicy[] policies;
        JackrabbitAccessControlList acl = null;
        for (AccessControlPolicy policy : policies = acm.getPolicies(path)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)policy;
        }
        if (acl == null) {
            AccessControlPolicyIterator app = acm.getApplicablePolicies(path);
            while (app.hasNext()) {
                AccessControlPolicy policy = app.nextAccessControlPolicy();
                if (!(policy instanceof JackrabbitAccessControlList)) continue;
                acl = (JackrabbitAccessControlList)policy;
            }
        }
        return acl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUpdates(Resource resource, Date ifModifiedSince) {
        this.lock.readLock().lock();
        Config config = (Config)resource.adaptTo(Config.class);
        Session session = (Session)resource.getResourceResolver().adaptTo(Session.class);
        try {
            boolean bl = this.getLatestTimestamp(config, session) > ifModifiedSince.getTime();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void cleanupCachedZips(Config config, Session session) {
        try {
            String zipsPath = ConfigUtil.configToCachePath(config, session) + ZIPS_SUFFIX;
            NodeIterator zips = session.getNode(zipsPath).getNodes("*.zip");
            String expr = ConfigUtil.getConfigName(config, session) + ".*" + this.getLatestTimestamp(config, session).toString() + "\\.zip";
            while (zips.hasNext()) {
                Node zipNode = zips.nextNode();
                if (zipNode.getName().matches(expr)) continue;
                log.info("Removing cached and now obsolete content sync zip: {}", (Object)zipNode.getPath());
                zipNode.remove();
            }
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Cache cleanup failed: ", (Throwable)e);
        }
    }

    private void clearCache(Config config, Session session) throws RepositoryException {
        String configParentPath = Text.getRelativeParent((String)ConfigUtil.configToCachePath(config, session), (int)1);
        if (session.nodeExists(configParentPath)) {
            NodeIterator nodes = session.getNode(configParentPath).getNodes();
            String expr = ConfigUtil.getConfigName(config, session) + "(.*\\.zip)?";
            while (nodes.hasNext()) {
                Node n = nodes.nextNode();
                if (!n.getName().matches(expr)) continue;
                n.remove();
            }
            session.save();
            log.info("Cleared cache for config: {}", (Object)config.getPath());
        }
    }

    private void addCacheTimestamp(Config config, Session session) {
        try {
            String cachePath = ConfigUtil.configToCachePath(config, session);
            Long timestamp = new Date().getTime();
            ValueFactory factory = session.getValueFactory();
            if (session.propertyExists(cachePath + "/" + "timestamps")) {
                Property timestampsProperty = session.getProperty(cachePath + "/" + "timestamps");
                ArrayList<Value> values = new ArrayList<Value>();
                CollectionUtils.addAll(values, (Object[])timestampsProperty.getValues());
                values.add(0, factory.createValue(timestamp.longValue()));
                timestampsProperty.setValue(values.toArray(new Value[values.size()]));
            } else {
                Node node = JcrUtil.createPath((String)cachePath, (String)DEFAULT_FOLDER_TYPE, (String)DEFAULT_FOLDER_TYPE, (Session)session, (boolean)false);
                Value[] values = new Value[]{factory.createValue(timestamp.longValue())};
                node.setProperty("timestamps", values);
            }
            session.save();
        }
        catch (RepositoryException e) {
            log.error("Could not add update timestamp: ", (Throwable)e);
        }
    }

    @Override
    public Long getLatestTimestamp(Config config, Session session) {
        try {
            String path = ConfigUtil.configToCachePath(config, session) + "/" + "timestamps";
            Property timestampsProperty = session.getProperty(path);
            return timestampsProperty.getValues()[0].getLong();
        }
        catch (RepositoryException e) {
            return new Date(0L).getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getZip(Resource resource, Date ifModifiedSince, Session session) throws RepositoryException, IOException {
        Config config = (Config)resource.adaptTo(Config.class);
        if (config != null) {
            String zipPath;
            Long before;
            String cachePath;
            block13: {
                if (!ConfigUtil.isCached(config, session) || ConfigUtil.isPersonalized(config.getPath(), session)) {
                    this.clearCache(config, session);
                    this.updateCache(config, session);
                    ifModifiedSince = null;
                }
                cachePath = ConfigUtil.configToCachePath(config, session);
                String zipsCachePath = cachePath + ZIPS_SUFFIX + "/" + ConfigUtil.getConfigName(config, session);
                before = null;
                zipPath = "";
                this.lock.readLock().lock();
                try {
                    Value[] timestamps = null;
                    try {
                        timestamps = session.getProperty(cachePath + "/" + "timestamps").getValues();
                    }
                    catch (RepositoryException e) {
                        log.warn("Missing timestamp property at {}. Most likely caused by an error in a ContentSync handler", (Object)cachePath);
                        throw e;
                    }
                    Long latest = timestamps[0].getLong();
                    zipPath = zipsCachePath + "." + latest.toString() + ".zip";
                    if (ifModifiedSince == null) break block13;
                    Long timestamp = ifModifiedSince.getTime();
                    if (timestamp < latest) {
                        for (Value v : timestamps) {
                            if (v.getLong() > timestamp) continue;
                            before = v.getLong();
                            break;
                        }
                        if (before != null && latest != before) {
                            zipPath = zipsCachePath + "." + before.toString() + "." + latest.toString() + ".zip";
                        }
                        break block13;
                    }
                    String string = null;
                    return string;
                }
                finally {
                    this.lock.readLock().unlock();
                }
            }
            if (!session.nodeExists(zipPath)) {
                try {
                    this.buildZip(session, zipPath, cachePath, before);
                }
                catch (LoginException e) {
                    log.error("Building zip file failed", (Throwable)e);
                }
            }
            return zipPath;
        }
        log.error("Not a valid content sync configuration at {}", (Object)resource.getPath());
        throw new IllegalArgumentException("Not a valid content sync configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildZip(Session session, String zipPath, String cachePath, Long lastUpdated) throws RepositoryException, IOException, LoginException {
        ResourceResolver rr = null;
        try {
            this.lock.writeLock().lock();
            CacheItemCollector collector = new CacheItemCollector(lastUpdated);
            session.getNode(cachePath).accept((ItemVisitor)collector);
            Iterator<Node> iter = collector.getNodes();
            if (iter.hasNext()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ZipOutputStream zip = new ZipOutputStream(out);
                HashMap<String, String> authInfo = new HashMap<String, String>();
                authInfo.put("user.impersonation", session.getUserID());
                rr = this.resolverFactory.getAdministrativeResourceResolver(authInfo);
                do {
                    Node file = iter.next();
                    log.info("Adding file to content sync zip: {}", (Object)file.getPath());
                    zip.putNextEntry(new ZipEntry(this.buildTargetPath(rr, cachePath, file.getPath())));
                    InputStream is = session.getProperty(file.getPath() + "/jcr:content/jcr:data").getBinary().getStream();
                    IOUtils.copy((InputStream)is, (OutputStream)zip);
                    zip.closeEntry();
                } while (iter.hasNext());
                this.buildManifest(session, cachePath, zip);
                zip.close();
                JcrUtil.createPath((String)zipPath, (String)DEFAULT_FOLDER_TYPE, (String)"nt:file", (Session)session, (boolean)false);
                Node contentNode = JcrUtil.createPath((String)(zipPath + "/jcr:content"), (String)"nt:resource", (Session)session);
                contentNode.setProperty("jcr:mimeType", "application/zip");
                contentNode.setProperty("jcr:data", session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(out.toByteArray())));
                session.save();
            }
        }
        finally {
            this.lock.writeLock().unlock();
            if (rr != null) {
                rr.close();
            }
        }
    }

    private String buildTargetPath(ResourceResolver rr, String cachePath, String path) {
        String mappedPath = rr.map(path);
        try {
            mappedPath = URLDecoder.decode(mappedPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Decoding failed: ", (Throwable)e);
        }
        return mappedPath.replaceFirst(cachePath + "/", "");
    }

    private void buildManifest(Session session, String cachePath, ZipOutputStream zip) throws RepositoryException, IOException {
        String manifestPath = ConfigUtil.cacheToConfigPath(cachePath) + "/manifest";
        if (session.nodeExists(manifestPath)) {
            StringBuffer buf = new StringBuffer();
            PropertyIterator props = session.getNode(manifestPath).getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (prop.getName().startsWith("jcr:")) continue;
                buf.append(prop.getName());
                buf.append(": ");
                buf.append(prop.getString());
                buf.append("\n");
            }
            zip.putNextEntry(new ZipEntry("manifest"));
            InputStream is = IOUtils.toInputStream((String)buf.toString(), (String)"utf-8");
            IOUtils.copy((InputStream)is, (OutputStream)zip);
            zip.closeEntry();
        }
    }

    @Override
    @Deprecated
    public void sendZip(HttpServletResponse response, String requestURI) {
        throw new UnsupportedOperationException("This method is deprecated for security reasons. Please use sendZip(Session, HttpServletResponse, String) instead.");
    }

    @Override
    public void sendZip(Session session, HttpServletResponse response, String requestURI) {
        try {
            long size = this.writeZip(session, (OutputStream)response.getOutputStream(), requestURI);
            response.setContentType("application/zip");
            response.setContentLength((int)size);
        }
        catch (Exception e) {
            log.error("Error while trying to send zip file: ", (Throwable)e);
        }
    }

    @Override
    public void sendZip(Session session, OutputStream out, String requestURI) {
        try {
            this.writeZip(session, out, requestURI);
        }
        catch (Exception e) {
            log.error("Error while trying to send zip file: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeZip(Session session, OutputStream out, String requestURI) throws RepositoryException, IOException {
        InputStream is;
        Binary binary;
        block5: {
            long l;
            binary = null;
            is = null;
            String cachePath = ConfigUtil.cachePathFromRequestURI(requestURI);
            try {
                if (!session.itemExists(cachePath)) break block5;
                binary = session.getProperty(cachePath).getBinary();
                is = binary.getStream();
                IOUtils.copy((InputStream)is, (OutputStream)out);
                l = binary.getSize();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                if (binary != null) {
                    binary.dispose();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            if (binary != null) {
                binary.dispose();
            }
            return l;
        }
        IOUtils.closeQuietly(is);
        if (binary != null) {
            binary.dispose();
        }
        return 0L;
    }

    @Override
    @Deprecated
    public Iterator<Config> getConfigs() {
        throw new UnsupportedOperationException("This method is deprecated for security reasons. Please use getConfigs(ResourceResolver) instead.");
    }

    @Override
    public Iterator<Config> getConfigs(ResourceResolver rr) {
        HashSet<Object> configs = new HashSet<Object>();
        try {
            Session s = (Session)rr.adaptTo(Session.class);
            Query configQuery = s.getWorkspace().getQueryManager().createQuery("SELECT * FROM [cq:ContentSyncConfig]", "JCR-SQL2");
            NodeIterator iter = configQuery.execute().getNodes();
            while (iter.hasNext()) {
                Node configNode = iter.nextNode();
                try {
                    configs.add(rr.getResource(configNode.getPath()).adaptTo(Config.class));
                }
                catch (RepositoryException e) {
                    log.error("Invalid content sync configuration found at {}", (Object)configNode.getPath());
                }
            }
        }
        catch (RepositoryException e) {
            log.error("Error while querying for content sync configs", (Throwable)e);
        }
        return configs.iterator();
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

