/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.config;

import com.day.cq.contentsync.config.Config;
import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.impl.config.ConfigEntryImpl;
import com.day.cq.contentsync.impl.config.ConfigImpl;
import com.day.cq.contentsync.impl.config.ConfigUtil;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.vendor", value={"Day Management AG"}), @Property(name="service.description", value={"Default Content Sync Config Adapter"})})
public class ConfigAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Class<Resource> RESOURCE_CLASS = Resource.class;
    private static final Class<Config> CONFIG_CLASS = Config.class;
    private static final Class<ConfigEntry> CONFIG_ENTRY_CLASS = ConfigEntry.class;
    @Property(name="adapters")
    protected static final String[] ADAPTER_CLASSES = new String[]{CONFIG_CLASS.getName(), CONFIG_ENTRY_CLASS.getName()};
    @Property(name="adaptables")
    protected static final String[] ADAPTABLE_CLASSES = new String[]{RESOURCE_CLASS.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof Resource) {
            return this.getAdapter((Resource)adaptable, type);
        }
        this.log.warn("Unable to handle adaptable {}", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(Resource resource, Class<AdapterType> type) {
        if (type == CONFIG_CLASS && ConfigUtil.isConfig(resource)) {
            return (AdapterType)new ConfigImpl(resource);
        }
        if (type == CONFIG_ENTRY_CLASS && ConfigUtil.isConfigEntry(resource)) {
            return (AdapterType)new ConfigEntryImpl(resource);
        }
        this.log.debug("Unable to adapt resource to type {}", (Object)type.getName());
        return null;
    }
}

