/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.config;

import com.day.cq.contentsync.config.Config;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;

public class ConfigUtil {
    public static final String CACHE_ROOT = "/var/contentsync";
    public static final String TIMESTAMPS_PROPERTY = "timestamps";
    @Deprecated
    private static final String CACHE_PROPERTY = "cache";

    public static String configToCachePath(Config config, Session session) throws RepositoryException {
        return CACHE_ROOT + Text.getRelativeParent((String)config.getPath(), (int)1) + "/" + ConfigUtil.getConfigName(config, session);
    }

    public static String cachePathFromRequestURI(String requestURI) {
        int pos = requestURI.lastIndexOf("/");
        StringBuilder cachePath = new StringBuilder(CACHE_ROOT);
        cachePath.append(requestURI.substring(0, pos));
        cachePath.append(requestURI.substring(pos).replaceFirst("(\\.\\d*)*.zip", ""));
        cachePath.append("-zips");
        cachePath.append(requestURI.substring(pos));
        cachePath.append("/jcr:content/jcr:data");
        return cachePath.toString();
    }

    public static String cacheToConfigPath(String path) {
        return path.startsWith(CACHE_ROOT) ? path.replaceFirst(CACHE_ROOT, "") : null;
    }

    public static boolean isConfig(Resource resource) {
        try {
            return ((Node)resource.adaptTo(Node.class)).isNodeType("cq:ContentSyncConfig");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public static boolean isConfigEntry(Resource resource) {
        try {
            Node node = (Node)resource.adaptTo(Node.class);
            return node.getParent().isNodeType("cq:ContentSyncConfig") && node.hasProperty("type") && node.hasProperty("path");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public static boolean isCached(Config config, Session session) throws RepositoryException {
        String cachePath = ConfigUtil.configToCachePath(config, session);
        return session.itemExists(cachePath) && session.itemExists(cachePath + "/" + TIMESTAMPS_PROPERTY);
    }

    public static boolean isPersonalized(String configPath, Session session) throws RepositoryException {
        String personalizedPath = configPath + "/" + "personalized";
        if (session.itemExists(personalizedPath)) {
            return session.getProperty(personalizedPath).getBoolean();
        }
        String cachePath = configPath + "/" + CACHE_PROPERTY;
        if (session.itemExists(cachePath)) {
            return !session.getProperty(cachePath).getBoolean();
        }
        return false;
    }

    public static String getConfigName(Config config, Session session) throws RepositoryException {
        if (ConfigUtil.isPersonalized(config.getPath(), session)) {
            return config.getName() + "." + session.getUserID();
        }
        return config.getName();
    }
}

