/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.handler;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.contentsync.impl.handler.HtmlLibraryUpdateHandler;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, factory="com.day.cq.contentsync.handler.ContentUpdateHandler/copy")
public class FileCopyUpdateHandler
implements ContentUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(HtmlLibraryUpdateHandler.class);
    @Reference
    private JcrResourceResolverFactory resolverFactory;

    @Override
    public boolean updateCacheEntry(ConfigEntry configEntry, Long lastUpdated, String configCacheRoot, Session admin, Session session) {
        try {
            boolean changed = false;
            Resource resource = this.resolverFactory.getResourceResolver(admin).getResource(configEntry.getContentPath());
            Iterator<Resource> files = this.getFiles(resource, admin);
            while (files.hasNext()) {
                Resource file = files.next();
                if (!this.isModified(file, lastUpdated, configCacheRoot, admin)) continue;
                String cachePath = configCacheRoot + file.getPath();
                JcrUtil.createPath((String)cachePath, (String)"sling:Folder", (String)"nt:file", (Session)admin, (boolean)false);
                Property dataProperty = admin.getProperty(file.getPath() + "/jcr:content/jcr:data");
                Node cacheContentNode = JcrUtil.createPath((String)(cachePath + "/jcr:content"), (String)"nt:resource", (Session)admin);
                cacheContentNode.setProperty("jcr:data", admin.getValueFactory().createBinary(dataProperty.getBinary().getStream()));
                cacheContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                changed = true;
            }
            admin.save();
            return changed;
        }
        catch (Exception e) {
            log.error("Update of cache entry failed for file: {}", (Object)configEntry.getContentPath());
            return false;
        }
    }

    protected Iterator<Resource> getFiles(Resource resource, Session session) throws RepositoryException {
        ArrayList<Resource> files = new ArrayList<Resource>();
        ResourceResolver resolver = this.resolverFactory.getResourceResolver(session);
        if (((Node)resource.adaptTo(Node.class)).isNodeType("nt:file")) {
            files.add(resource);
        } else {
            StringBuilder queryString = new StringBuilder("/jcr:root");
            queryString.append(resource.getPath());
            queryString.append("//element(*,nt:file)");
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString.toString(), "xpath");
            NodeIterator iter = query.execute().getNodes();
            while (iter.hasNext()) {
                files.add(resolver.getResource(iter.nextNode().getPath()));
            }
        }
        return files.iterator();
    }

    protected boolean isModified(Resource resource, Long lastUpdated, String configCacheRoot, Session session) throws RepositoryException {
        long lastModified = resource.getResourceMetadata().getModificationTime();
        return !session.nodeExists(configCacheRoot + resource.getPath()) || lastUpdated < lastModified || lastModified == -1L;
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

