/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.handler;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.widget.HtmlLibrary;
import com.day.cq.widget.HtmlLibraryManager;
import com.day.cq.widget.LibraryType;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, factory="com.day.cq.contentsync.handler.ContentUpdateHandler/clientlib")
public class HtmlLibraryUpdateHandler
implements ContentUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(HtmlLibraryUpdateHandler.class);
    private static final String PN_EXTENSION = "extension";
    @Reference
    private HtmlLibraryManager htmlLibraryManager;

    public boolean updateCacheEntry(ConfigEntry configEntry, Long lastUpdated, String configCacheRoot, Session admin, Session session) {
        HtmlLibrary lib = this.getHtmlLibrary(configEntry);
        boolean changed = false;
        try {
            if (lastUpdated < lib.getLastModified()) {
                String cachePath = configCacheRoot + lib.getPath();
                JcrUtil.createPath((String)cachePath, (String)"sling:Folder", (String)"nt:file", (Session)admin, (boolean)false);
                Node contentNode = JcrUtil.createPath((String)(cachePath + "/jcr:content"), (String)"nt:resource", (Session)admin);
                contentNode.setProperty("jcr:data", admin.getValueFactory().createBinary(lib.getInputStream()));
                contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                changed = true;
            }
            changed = this.updateImages(lib.getLibraryPath(), lastUpdated, configCacheRoot, admin) || changed;
            admin.save();
        }
        catch (Exception e) {
            log.error("Update of cache entry failed for HTML client library: {}", (Object)configEntry.getContentPath());
        }
        return changed;
    }

    protected HtmlLibrary getHtmlLibrary(ConfigEntry configEntry) {
        LibraryType type = configEntry.getValue(PN_EXTENSION).equals("css") ? LibraryType.CSS : LibraryType.JS;
        return this.htmlLibraryManager.getLibrary(type, configEntry.getContentPath());
    }

    protected boolean updateImages(String libPath, Long lastUpdated, String configCacheRoot, Session session) throws RepositoryException {
        NodeIterator iter = this.getImages(libPath, session);
        boolean changed = false;
        while (iter.hasNext()) {
            Node image = iter.nextNode();
            if (!this.isModified(image.getPath(), lastUpdated, configCacheRoot, session)) continue;
            Node parent = JcrUtil.createPath((String)(configCacheRoot + Text.getRelativeParent((String)image.getPath(), (int)1)), (String)"sling:Folder", (Session)session);
            JcrUtil.copy((Node)image, (Node)parent, (String)image.getName());
            changed = true;
        }
        return changed;
    }

    protected NodeIterator getImages(String libPath, Session session) throws RepositoryException {
        StringBuilder queryString = new StringBuilder("/jcr:root");
        queryString.append(libPath);
        queryString.append("//element(*,nt:file)[jcr:contains(jcr:content/@jcr:mimeType,'image/')]");
        Query query = session.getWorkspace().getQueryManager().createQuery(queryString.toString(), "xpath");
        return query.execute().getNodes();
    }

    protected boolean isModified(String path, Long lastModified, String configCacheRoot, Session session) throws RepositoryException {
        String imageLastModified = path + "/jcr:content/jcr:lastModified";
        return !session.nodeExists(configCacheRoot + path) || lastModified < session.getProperty(imageLastModified).getLong();
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }
}

