/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.handler;

import com.day.cq.contentsync.config.ConfigEntry;
import com.day.cq.contentsync.handler.AbstractSlingResourceUpdateHandler;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, factory="com.day.cq.contentsync.handler.ContentUpdateHandler/content")
public class RenderedResourceUpdateHandler
extends AbstractSlingResourceUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(RenderedResourceUpdateHandler.class);
    private static final String PN_EXTENSION = "extension";
    private static final String PN_SELECTOR = "selector";

    public boolean updateCacheEntry(ConfigEntry configEntry, Long lastUpdated, String configCacheRoot, Session admin, Session session) {
        try {
            String uri = RenderedResourceUpdateHandler.buildURI(configEntry);
            return this.renderResource(uri, configCacheRoot, admin, session);
        }
        catch (Exception e) {
            log.error("Failed to render resource for content sync cache update", (Throwable)e);
            return false;
        }
    }

    protected static String buildURI(ConfigEntry entry) {
        String uri = entry.getContentPath();
        if (entry.getValue(PN_SELECTOR) != null) {
            uri = uri + "." + entry.getValue(PN_SELECTOR);
        }
        if (entry.getValue(PN_EXTENSION) != null) {
            uri = uri + "." + entry.getValue(PN_EXTENSION);
        }
        return uri;
    }
}

