/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.servlets;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.contentsync.ContentSyncManager;
import com.day.cq.contentsync.config.Config;
import com.day.cq.contentsync.impl.config.ConfigUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="CQ Content Sync config list servlet")
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/contentsync/console/configs"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET", "POST"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"json"}, propertyPrivate=true)})
public class ConfigListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -2535015041406286180L;
    private static final Logger log = LoggerFactory.getLogger(ConfigListServlet.class);
    private static final String TIDY_PARAM = "tidy";
    private static final String ACTION_PARAM = "action";
    private static final String PATH_PARAM = "path";
    @Reference
    private ContentSyncManager contentSyncManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            String tidy = request.getParameter(TIDY_PARAM);
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            TidyJSONWriter json = new TidyJSONWriter((Writer)response.getWriter());
            json.setTidy("true".equals(tidy));
            json.object();
            json.key("configs").array();
            ResourceResolver resolver = request.getResourceResolver();
            Iterator<Config> configs = this.contentSyncManager.getConfigs(resolver);
            while (configs.hasNext()) {
                Config config = configs.next();
                Node node = (Node)resolver.getResource(config.getPath()).adaptTo(Node.class);
                String title = node.hasProperty("jcr:title") ? node.getProperty("jcr:title").getString() : config.getPath();
                boolean personalized = ConfigUtil.isPersonalized(config.getPath(), (Session)resolver.adaptTo(Session.class));
                json.object();
                json.key(PATH_PARAM).value((Object)config.getPath());
                json.key("title").value((Object)title);
                json.key("lastUpdated").value((Object)this.contentSyncManager.getLatestTimestamp(config, (Session)resolver.adaptTo(Session.class)));
                json.key("personalized").value(personalized);
                json.endObject();
            }
            json.endArray();
            json.endObject();
        }
        catch (Exception e) {
            log.error("Unexpected error while listing content sync configs: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Config config;
            String cachePath;
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            String action = request.getParameter(ACTION_PARAM);
            String path = request.getParameter(PATH_PARAM);
            if ("update".equals(action)) {
                Resource config2 = request.getResourceResolver().getResource(path);
                this.contentSyncManager.updateCache(config2, session);
            } else if ("clear".equals(action) && session.nodeExists(cachePath = ConfigUtil.configToCachePath(config = (Config)request.getResourceResolver().getResource(path).adaptTo(Config.class), session))) {
                session.getNode(cachePath).remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected error while updating content sync cache: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindContentSyncManager(ContentSyncManager contentSyncManager) {
        this.contentSyncManager = contentSyncManager;
    }

    protected void unbindContentSyncManager(ContentSyncManager contentSyncManager) {
        if (this.contentSyncManager == contentSyncManager) {
            this.contentSyncManager = null;
        }
    }
}

