/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.servlets;

import com.day.cq.contentsync.ContentSyncManager;
import java.io.IOException;
import java.util.Date;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="CQ Content Sync Diff Zip Servlet")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"contentsync/config"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"zip"}, propertyPrivate=true)})
public class ContentDiffZipServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 4572843577190321593L;
    protected static final Logger log = LoggerFactory.getLogger(ContentDiffZipServlet.class);
    @Reference
    private ContentSyncManager contentSyncManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            if (request.getRequestPathInfo().getSelectors().length > 0) {
                String contentPath = request.getRequestURI().substring(request.getContextPath().length());
                this.contentSyncManager.sendZip(session, (HttpServletResponse)response, contentPath);
            } else {
                String zipRedirectPath = null;
                Resource resource = request.getResource();
                long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                if (ifModifiedSince == -1L && request.getParameter("ifModifiedSince") != null && request.getParameter("ifModifiedSince").length() > 0) {
                    ifModifiedSince = new Long(request.getParameter("ifModifiedSince"));
                }
                log.debug("ifModifiedSince: " + ifModifiedSince);
                zipRedirectPath = ifModifiedSince != -1L ? this.contentSyncManager.getZip(resource, new Date(ifModifiedSince), session) : this.contentSyncManager.getZip(resource, null, session);
                log.debug("redirect path: " + zipRedirectPath);
                if (zipRedirectPath != null) {
                    response.sendRedirect(request.getContextPath() + zipRedirectPath);
                } else {
                    response.setStatus(304);
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindContentSyncManager(ContentSyncManager contentSyncManager) {
        this.contentSyncManager = contentSyncManager;
    }

    protected void unbindContentSyncManager(ContentSyncManager contentSyncManager) {
        if (this.contentSyncManager == contentSyncManager) {
            this.contentSyncManager = null;
        }
    }
}

