/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.impl.servlets;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.contentsync.ContentSyncManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Component(metatype=false, label="CQ Content Sync Check for Updates Servlet")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"contentsync/config"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"updates"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"json"}, propertyPrivate=true)})
public class UpdatesServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -2909081134019367825L;
    @Reference
    private ContentSyncManager contentSyncManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Resource resource = request.getResource();
            Date date = new Date();
            long ifModifiedSince = request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince != -1L) {
                date.setTime(ifModifiedSince);
            }
            boolean hasUpdates = this.contentSyncManager.hasUpdates(resource, new Date(ifModifiedSince));
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            TidyJSONWriter out = new TidyJSONWriter((Writer)response.getWriter());
            out.object();
            out.key("updates").value(hasUpdates);
            out.endObject();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void bindContentSyncManager(ContentSyncManager contentSyncManager) {
        this.contentSyncManager = contentSyncManager;
    }

    protected void unbindContentSyncManager(ContentSyncManager contentSyncManager) {
        if (this.contentSyncManager == contentSyncManager) {
            this.contentSyncManager = null;
        }
    }
}

