/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.retriever.RetrieverService;
import com.day.cq.retriever.RetrieverStorage;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

class ContentRetriever
implements RetrieverStorage {
    private final Node content;
    private final RetrieverService retriever;
    private final HttpClient client = new HttpClient();
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private int resCounter;
    private static final String JCR_ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789._";

    ContentRetriever(Node content, RetrieverService retriever) {
        this.content = content;
        this.retriever = retriever;
        this.client.getParams().setAuthenticationPreemptive(true);
        this.client.getState().setCredentials(new AuthScope(null, -1, null), (Credentials)new UsernamePasswordCredentials("admin", "admin"));
    }

    void retrieveContent(String url) throws Exception {
        this.retriever.retrieve(url, null, (RetrieverStorage)this);
        this.content.getSession().save();
    }

    public String maybeDownloadResource(String elementName, String attributeName, String resourceUri, Attributes attributes) throws IOException, RepositoryException {
        String result = null;
        if (this.mustDownloadResource(elementName, attributeName, resourceUri, attributes)) {
            Node message = this.content.getParent();
            Node embed = message.hasNode("embed") ? message.getNode("embed") : message.addNode("embed", "nt:folder");
            int lastSlash = resourceUri.lastIndexOf(47);
            String name = ContentRetriever.filterFilename(++this.resCounter + "_" + (lastSlash >= 0 ? resourceUri.substring(lastSlash + 1) : resourceUri));
            this.log.debug("Downloading resource {}, storing with filename={}", (Object)resourceUri, (Object)name);
            InputStream is = null;
            String mimeType = null;
            try {
                GetMethod m = new GetMethod(resourceUri);
                m.setDoAuthentication(true);
                this.client.executeMethod((HttpMethod)m);
                Header ct = m.getResponseHeader("Content-Type");
                mimeType = ct == null ? null : ct.getValue();
                is = m.getResponseBodyAsStream();
            }
            catch (Exception e) {
                this.log.info("Retrieval of resource " + resourceUri + " failed: " + e);
            }
            if (is != null) {
                this.createFileAndResourceNode(embed, name, is, mimeType, 0L);
                result = "cid:${file#" + name + "}";
            }
        }
        return result;
    }

    public boolean mustDownloadResource(String elementName, String attributeName, String resourceUri, Attributes attributes) throws IOException {
        return true;
    }

    public void storeContent(String htmlContent) throws IOException, RepositoryException {
        this.content.setProperty("html", htmlContent);
    }

    public void createFileAndResourceNode(Node parent, String nodeName, InputStream data, String mimeType, long lastModified) throws RepositoryException {
        Node ntFile = parent.addNode(nodeName, "nt:file");
        if (mimeType == null) {
            mimeType = DEFAULT_CONTENT_TYPE;
            this.log.debug("Missing content type for {}, using {}", (Object)ntFile.getPath(), (Object)mimeType);
        }
        if (lastModified <= 0L) {
            lastModified = System.currentTimeMillis();
        }
        Node resource = ntFile.addNode("jcr:content", "nt:resource");
        resource.setProperty("jcr:mimeType", mimeType);
        resource.setProperty("jcr:lastModified", lastModified);
        resource.setProperty("jcr:data", data);
    }

    static String filterFilename(String str) {
        StringBuffer sb = new StringBuffer();
        str = str.toLowerCase();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (JCR_ALLOWED_CHARS.indexOf(c) < 0) {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

