/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailService;
import java.util.Dictionary;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMailService
implements MailService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_SMTP_HOST = "smtp.example.com";
    private static final Integer DEFAULT_SMTP_PORT = 25;
    private static final Boolean DEFAULT_DEBUG_EMAIL = false;
    private static final Boolean DEFAULT_USE_SSL_CONNECTION = false;
    private static final String SMTP_HOST = "smtp.host";
    private static final String SMTP_PORT = "smtp.port";
    private static final String SMTP_USER = "smtp.user";
    private static final String SMTP_PASSWORD = "smtp.password";
    private static final String FROM_ADDRESS = "from.address";
    private static final String SMTP_SSL = "smtp.ssl";
    private static final String DEBUG_EMAIL = "debug.email";
    protected String smtpHost;
    protected int smtpPort;
    protected String smtpUser;
    protected String smtpPassword;
    protected String fromAddress;
    protected boolean debugEmail;
    protected boolean smtpSsl;

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.smtpHost = OsgiUtil.toString(properties.get(SMTP_HOST), (String)DEFAULT_SMTP_HOST);
        this.smtpPort = OsgiUtil.toInteger(properties.get(SMTP_PORT), (int)DEFAULT_SMTP_PORT);
        this.smtpUser = OsgiUtil.toString(properties.get(SMTP_USER), null);
        this.smtpPassword = OsgiUtil.toString(properties.get(SMTP_PASSWORD), null);
        this.fromAddress = (String)properties.get(FROM_ADDRESS);
        this.debugEmail = OsgiUtil.toBoolean(properties.get(DEBUG_EMAIL), (boolean)DEFAULT_DEBUG_EMAIL);
        this.smtpSsl = OsgiUtil.toBoolean(properties.get(SMTP_SSL), (boolean)DEFAULT_USE_SSL_CONNECTION);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MailService activated, fromAddress={}, smtpHost={}, smtpPort={}, debugEmail={}, smtpUser={}.", new Object[]{this.fromAddress, this.smtpHost, this.smtpPort, this.debugEmail, this.smtpUser == null ? "" : this.smtpUser});
        }
    }

    public void sendEmail(Email email) throws EmailException {
        email.setDebug(this.debugEmail);
        if (email.getFromAddress() == null) {
            if (this.fromAddress == null || this.fromAddress.trim().length() == 0) {
                throw new EmailException("fromAddress is null, cannot send messages");
            }
            email.setFrom(this.fromAddress);
        }
        boolean hasHostName = true;
        try {
            email.getHostName();
        }
        catch (NullPointerException npe) {
            hasHostName = false;
        }
        if (!hasHostName) {
            if (this.smtpHost == null || this.smtpHost.trim().length() == 0) {
                throw new EmailException("smptHost is null or empty, cannt send messages");
            }
            email.setHostName(this.smtpHost);
            if (this.smtpSsl) {
                email.setSSL(true);
                email.setSslSmtpPort(String.valueOf(this.smtpPort));
            } else {
                email.setSmtpPort(this.smtpPort);
            }
            if (this.smtpUser != null && this.smtpUser.trim().length() > 0) {
                email.setAuthentication(this.smtpUser, this.smtpPassword);
            }
        }
        email.send();
    }
}

