/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.impl.ContentRetriever;
import com.day.cq.mailer.impl.FileNodeAdapter;
import com.day.cq.mailer.impl.FileNodeDataSource;
import com.day.cq.mailer.impl.NodePropertiesVariableReplacer;
import com.day.cq.retriever.RetrieverService;
import java.util.LinkedList;
import java.util.List;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmailBuilder {
    private final String fromAddress;
    private final String subject;
    private String textContent;
    private String htmlContent;
    private final Node contentNode;
    private RetrieverService retriever;
    private final String charset = "UTF-8";
    public static final String FILE_VARIABLE_PREFIX = "file#";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    EmailBuilder(Node content) throws EmailException, RepositoryException {
        this.contentNode = content;
        this.fromAddress = this.getContentProperty("from") != null ? this.getContentProperty("from") : null;
        String error = this.getContentProperty("error");
        if (error != null) {
            throw new EmailException("Content error, cannot send message:" + error);
        }
        this.textContent = this.getContentProperty("text");
        this.htmlContent = this.getContentProperty("html");
        this.subject = this.getContentProperty("subject");
    }

    protected String getContentProperty(String propertyName) throws RepositoryException {
        Property p;
        String result = null;
        if (this.contentNode.hasProperty(propertyName) && (result = (p = this.contentNode.getProperty(propertyName)).getString().trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    Email createEmail(Property recipientEmail, NodePropertiesVariableReplacer vr) throws EmailException, RepositoryException {
        String subjectText;
        String url;
        if (this.textContent == null && this.htmlContent == null && this.getContentProperty("error") == null && (url = this.getContentProperty("url")) != null) {
            try {
                new ContentRetriever(this.contentNode, this.retriever).retrieveContent(url);
                this.textContent = this.getContentProperty("text");
                this.htmlContent = this.getContentProperty("html");
            }
            catch (Exception e) {
                this.contentNode.setProperty("error", "Exception while retrieving content: " + e);
            }
        }
        if (this.getContentProperty("error") != null) {
            throw new EmailException("Content node " + this.contentNode.getPath() + " has content error, cannot send (" + this.getContentProperty("error") + ")");
        }
        Email result = null;
        if (this.htmlContent != null) {
            result = this.createHtmlEmail(vr);
        } else if (this.textContent != null) {
            result = this.createPlainTextEmail(vr);
        } else {
            throw new EmailException("Content node " + this.contentNode.getPath() + " has no html and no text content, cannot send");
        }
        String to = recipientEmail.getString();
        String string = subjectText = vr == null ? this.subject : vr.replaceVariables(this.subject);
        if (this.log.isDebugEnabled()) {
            String info = "to=" + to + ", subject=" + subjectText;
            this.log.debug("Email created: {}, class={}", (Object)info, (Object)result.getClass().getSimpleName());
        }
        if (this.fromAddress != null) {
            result.setFrom(this.fromAddress);
        }
        result.addTo(to);
        result.setSubject(subjectText);
        return result;
    }

    private Email createPlainTextEmail(NodePropertiesVariableReplacer vr) throws EmailException, RepositoryException {
        SimpleEmail email = new SimpleEmail();
        email.setCharset("UTF-8");
        email.setMsg(vr == null ? this.textContent : vr.replaceVariables(this.textContent));
        return email;
    }

    private Email createHtmlEmail(NodePropertiesVariableReplacer vr) throws EmailException, RepositoryException {
        HtmlEmail email = new HtmlEmail();
        email.setCharset("UTF-8");
        this.embedFiles(email, vr);
        this.attachFiles(email);
        email.setHtmlMsg(vr == null ? this.htmlContent : vr.replaceVariables(this.htmlContent));
        if (this.textContent != null) {
            email.setTextMsg(vr == null ? this.textContent : vr.replaceVariables(this.textContent));
        }
        return email;
    }

    protected static List<Node> getFileNodes(Node base, String path) throws RepositoryException {
        LinkedList<Node> fileNodes = new LinkedList<Node>();
        if (base.hasNode(path)) {
            NodeIterator it = base.getNode(path).getNodes();
            while (it.hasNext()) {
                Node n = it.nextNode();
                if (!n.isNodeType("nt:file")) continue;
                fileNodes.add(n);
            }
        }
        return fileNodes;
    }

    protected void embedFiles(HtmlEmail email, NodePropertiesVariableReplacer vr) throws PathNotFoundException, RepositoryException, EmailException {
        for (Node n : EmailBuilder.getFileNodes(this.contentNode.getParent(), "embed")) {
            FileNodeAdapter f = new FileNodeAdapter(n);
            if (f.getContentLength() <= 0L) continue;
            if (this.log.isDebugEnabled()) {
                String info = "filename=" + f.getFilename() + ", ContentType=" + f.getContentType() + ", length=" + f.getContentLength();
                this.log.debug("Embedding file node {}: {}", (Object)n.getPath(), (Object)info);
            }
            String filename = f.getFilename();
            String ref = email.embed((DataSource)new FileNodeDataSource(f), filename);
            vr.setAdditionalProperty(FILE_VARIABLE_PREFIX + filename, ref);
        }
    }

    protected void attachFiles(HtmlEmail email) throws PathNotFoundException, RepositoryException, EmailException {
        for (Node n : EmailBuilder.getFileNodes(this.contentNode.getParent(), "attach")) {
            FileNodeAdapter f = new FileNodeAdapter(n);
            if (f.getContentLength() <= 0L) continue;
            if (this.log.isDebugEnabled()) {
                String info = "filename=" + f.getFilename() + ", ContentType=" + f.getContentType() + ", length=" + f.getContentLength();
                this.log.debug("Attaching file node {}: {}", (Object)n.getPath(), (Object)info);
            }
            String filename = f.getFilename();
            email.attach((DataSource)new FileNodeDataSource(f), filename, filename);
        }
    }

    public void setRetriever(RetrieverService retriever) {
        this.retriever = retriever;
    }
}

