/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class FileNodeAdapter {
    private final Node node;
    private Property dataProperty;
    private final String filename;
    private String contentType;
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    public FileNodeAdapter(Node n) throws RepositoryException {
        this.node = n;
        String name = n.getPath();
        this.filename = name.substring(name.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getDataProperty() throws RepositoryException {
        if (this.dataProperty == null) {
            FileNodeAdapter fileNodeAdapter = this;
            synchronized (fileNodeAdapter) {
                Node content;
                Node node = content = this.node.isNodeType("nt:file") ? this.node.getNode("jcr:content") : this.node;
                if (content.hasProperty("jcr:data")) {
                    this.dataProperty = content.getProperty("jcr:data");
                } else {
                    try {
                        Item item = content.getPrimaryItem();
                        while (item.isNode()) {
                            item = ((Node)item).getPrimaryItem();
                        }
                        this.dataProperty = (Property)item;
                    }
                    catch (ItemNotFoundException infe) {
                        this.dataProperty = null;
                    }
                }
            }
        }
        return this.dataProperty;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() throws RepositoryException {
        if (this.contentType == null) {
            this.getDataProperty();
            if (this.dataProperty != null && this.dataProperty.getParent().hasProperty("jcr:mimeType")) {
                this.contentType = this.dataProperty.getParent().getProperty("jcr:mimeType").getString();
            }
        }
        if (this.contentType == null) {
            this.contentType = DEFAULT_CONTENT_TYPE;
        }
        return this.contentType;
    }

    public long getContentLength() throws RepositoryException {
        if (this.getDataProperty() == null) {
            return 0L;
        }
        return this.getDataProperty().getLength();
    }
}

