/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.impl.FileNodeAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.jcr.RepositoryException;

public class FileNodeDataSource
implements DataSource {
    private final FileNodeAdapter fna;

    public FileNodeDataSource(FileNodeAdapter f) {
        this.fna = f;
    }

    public String getContentType() {
        try {
            return this.fna.getContentType();
        }
        catch (RepositoryException re) {
            throw new PropertyDataSourceException("getContentType failed", re);
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.fna.getDataProperty().getStream();
        }
        catch (RepositoryException re) {
            IOException ioe = new IOException("Property.getStream failed");
            ioe.initCause(re);
            throw ioe;
        }
    }

    public String getName() {
        return this.fna.getFilename();
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException(this.getClass().getName() + " is not writable");
    }

    public static class PropertyDataSourceException
    extends RuntimeException {
        PropertyDataSourceException(String reason, Throwable t) {
            super(reason, t);
        }
    }
}

