/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailService;
import com.day.cq.mailer.impl.SenderTask;
import com.day.cq.retriever.RetrieverService;
import java.util.Dictionary;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerService
implements Runnable,
EventListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String DATA_ROOT_PATH = "data.root.path";
    private Scheduler scheduler;
    private RetrieverService retriever;
    protected SlingRepository repository;
    protected MailService mailService;
    private String mailDataRootPath;
    private Session session;
    private boolean mailDataChanged;
    private SenderTask senderTask;
    private boolean running;

    protected void activate(ComponentContext componentContext) throws Exception {
        Dictionary properties = componentContext.getProperties();
        this.mailDataRootPath = (String)properties.get(DATA_ROOT_PATH);
        Session s = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        s.getWorkspace().getObservationManager().addEventListener((EventListener)this, 31, this.mailDataRootPath, true, null, null, true);
        this.mailDataChanged = true;
        this.session = s;
        this.log.info("Activated, mailer cycle is active");
        this.scheduler.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext componentContext) {
        this.log.info("Deactivated, mailer cycle will be stopped");
        MailerService mailerService = this;
        synchronized (mailerService) {
            if (this.senderTask != null) {
                this.senderTask.stop();
            }
        }
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.running) {
            this.log.warn("run() method called concurrently, should not happen");
            return;
        }
        try {
            this.running = true;
            if (this.mailDataChanged && this.session != null) {
                this.mailDataChanged = false;
                try {
                    this.log.debug("mail data changed, starting mailer cycle");
                    this.runOneCycle();
                }
                catch (Exception e) {
                    this.log.warn("Exception in run()", (Throwable)e);
                }
            } else {
                this.log.debug("no change in mail data, not running mailer cycle");
            }
        }
        finally {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOneCycle() throws Exception {
        if (!this.session.itemExists(this.mailDataRootPath)) {
            this.log.debug("Node " + this.mailDataRootPath + " not found, not running mailer cycle");
            return;
        }
        Node mailDataRoot = (Node)this.session.getItem(this.mailDataRootPath);
        this.senderTask = new SenderTask(mailDataRoot, this.mailService);
        this.senderTask.setRetriever(this.retriever);
        this.senderTask.call();
        if (this.senderTask.getMessagesSent() > 0) {
            this.log.info("{} messages sent", (Object)this.senderTask.getMessagesSent());
        } else {
            this.log.debug("No messages sent");
        }
        MailerService mailerService = this;
        synchronized (mailerService) {
            this.senderTask = null;
        }
    }

    public void onEvent(EventIterator it) {
        if (!this.mailDataChanged) {
            this.mailDataChanged = true;
            this.log.debug("Data changed under " + this.mailDataRootPath + ", will trigger mailer cycle");
        }
    }

    protected void bindRetriever(RetrieverService retrieverService) {
        this.retriever = retrieverService;
    }

    protected void unbindRetriever(RetrieverService retrieverService) {
        if (this.retriever == retrieverService) {
            this.retriever = null;
        }
    }

    protected void bindMailService(MailService mailService) {
        this.mailService = mailService;
    }

    protected void unbindMailService(MailService mailService) {
        if (this.mailService == mailService) {
            this.mailService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void unbindScheduler(Scheduler scheduler) {
        if (this.scheduler == scheduler) {
            this.scheduler = null;
        }
    }
}

