/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailService;
import com.day.cq.mailer.impl.DoNothingItemVisitor;
import com.day.cq.mailer.impl.EmailBuilder;
import com.day.cq.mailer.impl.NodePropertiesVariableReplacer;
import com.day.cq.retriever.RetrieverService;
import java.util.concurrent.Callable;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryManager;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenderTask
implements Callable<Object> {
    private final Node mailerDataRoot;
    private int messagesSent;
    private boolean replaceVariables = true;
    private boolean running = true;
    private RetrieverService retriever;
    private final MailService mailService;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public SenderTask(Node mailerDataRoot, MailService mailService) {
        this.mailerDataRoot = mailerDataRoot;
        this.mailService = mailService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String queryBasePath = this.mailerDataRoot.getPath().substring(1);
            String query = queryBasePath + "//element(*,cq:mailerMessage)[@messageStatus != 'done']";
            this.log.debug("Looking for mailer messages to process, query={}", (Object)query);
            QueryManager qm = this.mailerDataRoot.getSession().getWorkspace().getQueryManager();
            NodeIterator it = qm.createQuery(query, "xpath").execute().getNodes();
            while (it.hasNext()) {
                Node message = it.nextNode();
                if (message.hasNode("recipients")) {
                    this.log.debug("Visiting recipients of message node {}", (Object)message.getPath());
                    this.visitRecipients(message.getNode("recipients"));
                } else {
                    this.log.debug("Node {} has no {} child, ignored", (Object)message.getPath(), (Object)"recipients");
                }
                message.setProperty("messageStatus", "done");
                message.getSession().save();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return null;
    }

    public void stop() {
        this.running = false;
    }

    protected void visitRecipients(Node n) throws EmailException, RepositoryException {
        if (!n.getParent().hasNode("jcr:content")) {
            return;
        }
        final EmailBuilder emailBuilder = new EmailBuilder(n.getParent().getNode("jcr:content"));
        emailBuilder.setRetriever(this.retriever);
        int maxLevels = 5;
        new DoNothingItemVisitor(false, maxLevels){

            protected void entering(Property p, int level) throws RepositoryException {
                if (SenderTask.this.running && p.getName().equals("email")) {
                    if (p.getParent().hasProperty("status")) {
                        SenderTask.this.log.debug("Recipients node {} already has status property, ignored", (Object)p.getParent().getPath());
                    } else {
                        SenderTask.this.sendEmail(emailBuilder, p);
                        p.getSession().save();
                    }
                }
            }
        }.visit(n);
    }

    protected void sendEmail(EmailBuilder emailBuilder, Property recipientEmail) throws RepositoryException {
        Node recipient = recipientEmail.getParent();
        NodePropertiesVariableReplacer vr = null;
        if (this.replaceVariables) {
            vr = new NodePropertiesVariableReplacer(recipient);
        }
        try {
            Email e = emailBuilder.createEmail(recipientEmail, vr);
            this.mailService.sendEmail(e);
            this.log.debug("sendEmail successful");
            recipient.setProperty("status", "sent");
            ++this.messagesSent;
        }
        catch (EmailException e) {
            this.log.info("sendEmail failed", (Throwable)e);
            recipient.setProperty("status", "error:" + e.toString());
        }
    }

    public boolean getReplaceVariables() {
        return this.replaceVariables;
    }

    public void setReplaceVariables(boolean replaceVariables) {
        this.replaceVariables = replaceVariables;
    }

    public int getMessagesSent() {
        return this.messagesSent;
    }

    public void setRetriever(RetrieverService retriever) {
        this.retriever = retriever;
    }
}

