/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailingException;
import com.day.cq.mailer.MailingList;
import com.day.cq.mailer.MailingService;
import com.day.cq.mailer.MailingStatus;
import com.day.cq.mailer.MailingStatusCode;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageGatewayService;
import com.day.cq.mailer.MessageTemplate;
import com.day.cq.mailer.impl.CqMailing;
import com.day.cq.mailer.impl.CqMailingStatus;
import com.day.cq.mailer.impl.MailingStatusManager;
import com.day.cq.mailer.impl.email.AbstractNodeEmailTemplate;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqMailingService
implements MailingService,
MessageGatewayService {
    private static final String GATEWAY_NAME = "mailingGateway";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String STATUS_PATH = "mailer.status.rootPath";
    protected SlingRepository repository;
    private String statusPath;
    private Session session;
    private ComponentContext osgiContext;
    private HashSet<MessageGateway> gateways;
    private final Map<ServiceReference, String> delayed = new HashMap<ServiceReference, String>();
    private final Object scrLock = new Object();
    private MailingStatusManager statusManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Type> MessageGateway<Type> getGateway(Class<? extends Type> type) {
        Object object = this.scrLock;
        synchronized (object) {
            for (MessageGateway gtw : this.gateways) {
                if (!gtw.handles(type)) continue;
                return gtw;
            }
        }
        return null;
    }

    @Override
    public MailingStatus getStatus(String mailingId) throws RepositoryException {
        return this.statusManager.getStatus(mailingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailingStatus send(MessageTemplate message, MailingList recipients, Session session) throws MailingException, RepositoryException {
        if (!session.nodeExists(this.statusPath)) {
            throw new AccessDeniedException(String.format("User %s not allowed to write in mailer data: starting mailer not allowed", session.getUserID()));
        }
        String subject = message instanceof AbstractNodeEmailTemplate ? Text.escapeIllegalJcrChars((String)((AbstractNodeEmailTemplate)message).getSubject()) : message.getType().getSimpleName();
        CqMailingStatus status = this.statusManager.createStatus(subject);
        CqMailing mailing = new CqMailing(status, message, recipients, this.statusManager);
        try {
            MessageGateway gateway = this.getGateway(mailing.getTemplate().getType());
            if (gateway != null) {
                this.log.debug("Found Gateway to send Mailing: {}", gateway);
                mailing.send(gateway);
            } else {
                this.log.debug("No gateway found for Mailing {} of type {}: did not send. Please register a gateway service for this type", (Object)mailing.getID(), (Object)mailing.getType());
                status.setStatus(MailingStatusCode.NO_GATEWAY);
            }
        }
        catch (MailingException e) {
            if (e.getCause() instanceof RepositoryException) {
                status.setError(e);
                throw e;
            }
        }
        finally {
            this.statusManager.save(status);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext componentContext) throws Exception {
        Dictionary properties = componentContext.getProperties();
        this.osgiContext = componentContext;
        Object object = this.scrLock;
        synchronized (object) {
            this.gateways = new HashSet();
            for (ServiceReference ref : this.delayed.keySet()) {
                String type = this.delayed.get(ref);
                this.addGateway(ref);
            }
        }
        this.statusPath = (String)properties.get(STATUS_PATH);
        this.statusManager = new MailingStatusManager(this.repository, this.statusPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext componentContext) {
        Object object = this.scrLock;
        synchronized (object) {
            if (this.session != null) {
                this.session.logout();
                this.session = null;
            }
            this.log.info("Deactivated: mailer cycle stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindMailingGateway(ServiceReference ref) {
        Object object = this.scrLock;
        synchronized (object) {
            if (this.osgiContext == null) {
                this.delayed.put(ref, GATEWAY_NAME);
            } else {
                MessageGateway gateway = (MessageGateway)this.osgiContext.locateService(GATEWAY_NAME, ref);
                if (gateway != null) {
                    this.gateways.add(gateway);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindMailingGateway(ServiceReference ref) {
        Object object = this.scrLock;
        synchronized (object) {
            if (this.osgiContext == null) {
                this.delayed.remove(ref);
            } else {
                MessageGateway gateway = (MessageGateway)this.osgiContext.locateService(GATEWAY_NAME, ref);
                this.gateways.remove(gateway);
            }
        }
    }

    private void addGateway(ServiceReference ref) {
        MessageGateway mg = (MessageGateway)this.osgiContext.locateService(GATEWAY_NAME, ref);
        if (mg != null) {
            this.gateways.add(mg);
            this.log.debug("Registered Gateway {} ", (Object)mg);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

