/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.mailer.impl.email.AbstractEmailTemplate;
import com.day.cq.mailer.impl.email.ResourceDataSource;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.MultiPartEmail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeEmailTemplate<Type extends MultiPartEmail>
extends AbstractEmailTemplate<Type> {
    protected static final String PROPERTY_FROM = "from";
    protected static final String PROPERTY_SUBJECT = "subject";
    protected static final String PROPERTY_TEXT = "text";
    protected static final String PATH_ATTACHMENTS = "attachments";
    protected static final String PATH_TEXT = "jcr:content/text";

    protected AbstractNodeEmailTemplate(Node content) throws RepositoryException {
        if (content.hasNode("jcr:content")) {
            this.load(content.getNode("jcr:content"));
        }
    }

    HashSet<ResourceDataSource> collectResources(NodeIterator itr) throws RepositoryException {
        HashSet<ResourceDataSource> nodes = new HashSet<ResourceDataSource>();
        while (itr.hasNext()) {
            Property prop;
            Node cand = itr.nextNode();
            if (!cand.isNodeType("nt:file")) continue;
            if ((cand = (Node)cand.getPrimaryItem()).isNodeType("nt:resource")) {
                nodes.add(new ResourceDataSource(cand));
                continue;
            }
            if (!cand.hasProperty("jcr:data") || (prop = cand.getProperty("jcr:data")).getType() != 2) continue;
            nodes.add(new ResourceDataSource(cand));
        }
        return nodes;
    }

    private void load(Node node) throws RepositoryException {
        if (node.hasProperty(PROPERTY_FROM)) {
            try {
                this.setFrom(new InternetAddress(node.getProperty(PROPERTY_FROM).getString()));
            }
            catch (AddressException ignore) {
                // empty catch block
            }
        }
        if (node.hasProperty(PROPERTY_SUBJECT)) {
            this.setSubject(node.getProperty(PROPERTY_SUBJECT).getString());
        }
        if (node.hasProperty(PROPERTY_TEXT)) {
            this.setText(node.getProperty(PROPERTY_TEXT).getString());
        }
        Node attachmentNode = null;
        if (node.hasNode(PATH_ATTACHMENTS)) {
            attachmentNode = node.getNode(PATH_ATTACHMENTS);
        }
        if (attachmentNode != null) {
            HashSet<ResourceDataSource> p = this.collectResources(attachmentNode.getNodes());
            for (ResourceDataSource att : p) {
                this.addAttachment(att);
            }
        }
    }
}

