/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.mailer.commons.ProfileVariableLookup;
import com.day.cq.mailer.commons.ProfileVariableSubstitutor;
import com.day.cq.mailer.impl.email.AbstractNodeEmailTemplate;
import com.day.cq.mailer.impl.email.ResourceDataSource;
import com.day.cq.security.profile.Profile;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEMailTemplate
extends AbstractNodeEmailTemplate<HtmlEmail> {
    protected static final String PROPERTY_HTML = "html";
    protected static final String PROPERTY_EMBEDDED = "embedded";
    private static final String PATH_HTML = "jcr:content/html";
    private static final String[] PATH_CHAR = JcrUtil.STANDARD_LABEL_CHAR_MAPPING;
    private String html;
    private final HashMap<String, DataSource> embed = new HashMap();

    public HtmlEMailTemplate(Node node) throws RepositoryException {
        super(node);
        if (node.hasNode("jcr:content")) {
            if ((node = node.getNode("jcr:content")).hasProperty(PROPERTY_HTML)) {
                this.setHtml(node.getProperty(PROPERTY_HTML).getString());
            }
            if (node.hasNode(PROPERTY_EMBEDDED)) {
                for (ResourceDataSource embd : this.collectResources(node.getNode(PROPERTY_EMBEDDED).getNodes())) {
                    this.addEmbedded(embd.getName(), embd);
                }
            }
        }
    }

    static boolean handles(Node node) throws RepositoryException {
        return node != null && node.hasProperty(PATH_HTML);
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public boolean addEmbedded(String name, DataSource data) {
        return this.embed.put(name, data) == null;
    }

    @Override
    public Class<HtmlEmail> getType() {
        return HtmlEmail.class;
    }

    @Override
    protected HtmlEmail doBuild(HtmlEmail mail, Profile recipient, ProfileVariableLookup vr) throws EmailException, RepositoryException {
        for (Map.Entry<String, DataSource> entry : this.embed.entrySet()) {
            DataSource res = entry.getValue();
            String ref = mail.embed(res, res.getName(), res.getName());
            vr.put(entry.getKey(), ref);
            vr.put("file#" + entry.getKey(), ref);
        }
        ProfileVariableSubstitutor sub = new ProfileVariableSubstitutor(vr);
        mail.setHtmlMsg(sub.replace(this.html, true));
        if (this.getText() != null) {
            mail.setTextMsg(sub.replace(this.getText(), true));
        }
        return mail;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            for (DataSource src : this.embed.values()) {
                if (!(src instanceof ResourceDataSource)) continue;
                ((ResourceDataSource)src).dispose();
            }
            super.dispose();
        }
    }

    static {
        HtmlEMailTemplate.PATH_CHAR[46] = ".";
    }
}

