/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailingException;
import com.day.cq.mailer.MailingList;
import com.day.cq.mailer.MailingStatusCode;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageTemplate;
import com.day.cq.mailer.impl.CqMailingStatus;
import com.day.cq.mailer.impl.Mailing;
import com.day.cq.mailer.impl.MailingRecipient;
import com.day.cq.mailer.impl.MailingStatusManager;
import com.day.cq.security.Authorizable;
import com.day.cq.security.profile.Profile;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqMailing
implements Mailing {
    static final String NAME_RECIPIENTS = "recipients";
    private static final String DEFAULT_TYPE = "email";
    private static final Logger log = LoggerFactory.getLogger(CqMailing.class);
    private MessageTemplate template;
    private MailingList recipients;
    private final String path;
    private final MailingStatusManager statusMgr;
    private final CqMailingStatus status;

    CqMailing(CqMailingStatus status, MessageTemplate message, MailingList recipients, MailingStatusManager statusManager) throws RepositoryException {
        this.statusMgr = statusManager;
        this.status = status;
        this.path = status.getPath();
        this.recipients = recipients;
        this.setTemplate(message);
    }

    void setTemplate(MessageTemplate template) {
        this.template = template;
    }

    @Override
    public String getID() throws RepositoryException {
        return this.path;
    }

    @Override
    public String getType() {
        return DEFAULT_TYPE;
    }

    @Override
    public MessageTemplate getTemplate() {
        return this.template;
    }

    @Override
    public Iterator<? extends MailingRecipient> getRecipients() throws RepositoryException {
        if (this.recipients == null) {
            return IteratorUtils.emptyIterator();
        }
        return IteratorUtils.transformedIterator(this.recipients.members(), (Transformer)new Transformer(){

            public Object transform(Object input) {
                try {
                    return CqMailing.this.authorizableToRecipient((Authorizable)input);
                }
                catch (RepositoryException e) {
                    log.error("Failed to create Status for {}: {}", (Object)((Authorizable)input).getID(), (Object)e);
                    throw new FunctorException((Throwable)e);
                }
            }
        });
    }

    @Override
    public CqMailingStatus getStatus() {
        return this.status;
    }

    @Override
    public boolean send(MessageGateway gateway) throws MailingException {
        assert (gateway != null);
        try {
            MessageTemplate template = this.getTemplate();
            if (template == null) {
                throw new IllegalStateException("Set a MessageTemplate first");
            }
            if (!gateway.handles(template.getType())) {
                this.status.setStatus(MailingStatusCode.NO_GATEWAY);
                return false;
            }
            Iterator<Authorizable> listMembers = this.recipients.members();
            while (listMembers.hasNext()) {
                Object msg;
                Authorizable auth = listMembers.next();
                CqMailingStatus rcpStatus = this.statusMgr.createStatus(this.path, auth);
                this.status.addRecipient(rcpStatus);
                try {
                    msg = template.buildMessage(auth.getProfile());
                    if (msg == null) {
                        log.debug("Recipient {} has no address for Mailing type {}", (Object)auth.getID(), (Object)this.getType());
                        rcpStatus.setStatus(MailingStatusCode.NO_ADDRESS);
                        continue;
                    }
                }
                catch (MailingException e) {
                    this.status.setStatus(MailingStatusCode.NO_TEMPLATE);
                    throw e;
                }
                try {
                    gateway.send(msg);
                    rcpStatus.setSent();
                    this.status.addSent();
                    log.debug("Message sent for Recipient {}", (Object)auth.getID());
                }
                catch (MailingException e) {
                    this.status.setError(e);
                    this.status.setStatus(MailingStatusCode.NOT_DELIVERABLE);
                    throw e;
                }
            }
            this.status.setSent();
            return true;
        }
        catch (RepositoryException e) {
            log.debug("Failed send mailing {}: {}", (Object)this.path, (Object)e);
            throw new MailingException(e);
        }
    }

    private MailingRecipient authorizableToRecipient(Authorizable auth) throws RepositoryException {
        final Profile profile = auth.getProfile();
        final CqMailingStatus rcpStatus = this.statusMgr.getStatus(this.path, auth) == null ? this.statusMgr.createStatus(this.path, auth) : this.statusMgr.getStatus(this.path, auth);
        return new MailingRecipient(){

            public Profile getProfile() {
                return profile;
            }

            public CqMailingStatus getStatus() {
                return rcpStatus;
            }
        };
    }
}

