/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.mailer.MailingStatusCode;
import com.day.cq.mailer.impl.CqMailingStatus;
import com.day.cq.security.Authorizable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MailingStatusManager {
    private static final Logger log = LoggerFactory.getLogger(MailingStatusManager.class);
    protected static final String TYPE_MESSAGE = "cq:mailerMessage";
    private static final String PROP_MESSAGE_TRACE = "errorMessages";
    private static final String PROP_MESSAGE_NUM = "numRecipients";
    static final String PROP_MESSAGE_STATUS = "messageStatus";
    private final SlingRepository repository;
    private final String root;

    MailingStatusManager(SlingRepository repository, String root) throws RepositoryException {
        this.repository = repository;
        this.root = root;
        Session s = repository.loginAdministrative(repository.getDefaultWorkspace());
        try {
            this.getRoot(s);
        }
        catch (RepositoryException e) {
            log.error("Failed to store create mail-data root path at {}: {}", (Object)root, (Object)e);
            throw e;
        }
        finally {
            if (s != null) {
                if (s.hasPendingChanges()) {
                    s.save();
                }
                s.logout();
            }
        }
    }

    public CqMailingStatus createStatus(String name) throws RepositoryException {
        Calendar cal = Calendar.getInstance();
        String path = String.format("%1$s/%2$tY/%2$tm/%2$td/%3$s-%2$tH%2$tM%2$tS%2$tL", this.root, cal, Text.escapeIllegalJcrChars((String)name));
        return new CqMailingStatus(path, cal.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqMailingStatus getStatus(String path) throws RepositoryException {
        Session s = null;
        path = this.absolute(path);
        try {
            s = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
            if (s.nodeExists(path)) {
                CqMailingStatus cqMailingStatus = this.read(s.getNode(path));
                return cqMailingStatus;
            }
            CqMailingStatus cqMailingStatus = null;
            return cqMailingStatus;
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(CqMailingStatus status) throws RepositoryException {
        Session s = null;
        try {
            s = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
            Node node = this.getOrCreate(status.getPath(), s);
            this.write(status, node);
            for (CqMailingStatus rcp : status.getRecipients()) {
                Node rcpNode = this.getOrCreate(rcp.getPath(), s);
                this.write(rcp, PROP_MESSAGE_STATUS, rcpNode);
            }
            if (s.hasPendingChanges()) {
                s.save();
            }
        }
        finally {
            if (s != null) {
                s.logout();
            }
        }
    }

    CqMailingStatus createStatus(String path, Authorizable auth) throws RepositoryException {
        return new CqMailingStatus(this.getRecipientStatusPath(path, auth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CqMailingStatus getStatus(String path, Authorizable auth) throws RepositoryException {
        Session session = null;
        String absPath = this.getRecipientStatusPath(path, auth);
        try {
            session = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
            if (session.nodeExists(absPath)) {
                CqMailingStatus cqMailingStatus = this.read(session.getNode(absPath));
                return cqMailingStatus;
            }
            CqMailingStatus cqMailingStatus = null;
            return cqMailingStatus;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private String getRecipientStatusPath(String path, Authorizable auth) {
        return String.format("%s/preferences/mailer/%s", auth.getHomePath(), Text.getName((String)path));
    }

    private void write(CqMailingStatus status, String propName, Node node) throws RepositoryException {
        node.setProperty(propName, status.getStatusCode().name());
    }

    private CqMailingStatus read(Node node) throws RepositoryException {
        CqMailingStatus status = new CqMailingStatus(node.getPath());
        String prop = MailingStatusManager.getSave(node, PROP_MESSAGE_STATUS);
        try {
            if (prop != null) {
                status.setStatus(MailingStatusCode.valueOf(prop));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("Wrong status code saved {}: set status New", (Object)prop);
        }
        if (node.hasProperty(PROP_MESSAGE_TRACE)) {
            Value[] vals = node.getProperty(PROP_MESSAGE_TRACE).getValues();
            status.setErrors(vals);
        }
        if (node.hasProperty("jcr:lastModified")) {
            status.setLastModified(node.getProperty("jcr:lastModified").getValue().getDate());
        }
        return status;
    }

    void write(CqMailingStatus status, Node node) throws RepositoryException {
        node.setProperty(PROP_MESSAGE_STATUS, status.getStatusCode().name());
        if (!status.getErrorMessages().isEmpty()) {
            JcrUtil.setProperty((Node)node, (String)PROP_MESSAGE_TRACE, (Object)status.getErrorMessages().toArray());
        }
        if (status.numSent() > -1L) {
            node.setProperty(PROP_MESSAGE_NUM, status.numSent());
        }
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(status.getLastModified());
        node.setProperty("jcr:lastModified", cal);
    }

    private static String getSave(Node node, String propName) {
        try {
            if (node.hasProperty(propName)) {
                return node.getProperty(propName).getString().trim();
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to access Property {}: {}", (Object)propName, (Object)e);
        }
        return null;
    }

    private Node getRoot(Session session) throws RepositoryException {
        if (!session.nodeExists(this.root)) {
            try {
                return JcrUtil.createPath((String)this.root, (String)"nt:unstructured", (Session)session);
            }
            catch (RepositoryException e) {
                log.error("Failed to store create mail-data root path at {}: {}", (Object)this.root, (Object)e);
                session.refresh(false);
                throw e;
            }
        }
        return session.getNode(this.root);
    }

    private Node getOrCreate(String path, Session session) throws RepositoryException {
        Node node;
        if (session.nodeExists(path = this.absolute(path))) {
            node = session.getNode(path);
        } else {
            this.getRoot(session);
            node = JcrUtil.createPath((String)path, (String)"nt:unstructured", (Session)session);
            node.addMixin(TYPE_MESSAGE);
        }
        return node;
    }

    private String absolute(String path) {
        assert (path != null);
        if (!path.startsWith("/")) {
            return this.root + "/" + path;
        }
        return path;
    }
}

