/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.mailer.email.EmailTemplateFactory;
import com.day.cq.mailer.impl.email.AbstractNodeEmailTemplate;
import com.day.cq.mailer.impl.email.HtmlEMailTemplate;
import com.day.cq.mailer.impl.email.SimpleEMailTemplate;
import java.nio.charset.Charset;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqEmailTemplateFactory
implements EmailTemplateFactory {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private String PROP_CHAR_SET = "mailer.email.charset";
    private Charset charSet = Charset.forName("UTF-8");

    public boolean handles(Resource resource) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        return node != null && (HtmlEMailTemplate.handles(node) || SimpleEMailTemplate.handles(node));
    }

    public AbstractNodeEmailTemplate<? extends MultiPartEmail> create(Resource resource) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        AbstractNodeEmailTemplate tmpl = null;
        if (HtmlEMailTemplate.handles(node)) {
            tmpl = new HtmlEMailTemplate(node);
        } else if (SimpleEMailTemplate.handles(node)) {
            tmpl = new SimpleEMailTemplate(node);
        }
        if (this.charSet != null && tmpl != null) {
            tmpl.setCharSet(this.charSet);
        }
        return tmpl;
    }

    protected void activate(ComponentContext ctx) {
        this.charSet = Charset.forName((String)ctx.getProperties().get(this.PROP_CHAR_SET));
    }
}

