/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.activation.DataSource;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

final class ResourceDataSource
implements DataSource {
    private final Node resNode;
    private final String name;
    private final HashSet<Binary> usedBinaries;

    public ResourceDataSource(Node resNode) throws RepositoryException {
        this.resNode = resNode;
        this.name = resNode.hasProperty("jcr:title") ? resNode.getProperty("jcr:title").getString() : resNode.getParent().getName();
        this.usedBinaries = new HashSet();
    }

    public void dispose() {
        for (Binary bin : this.usedBinaries) {
            bin.dispose();
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            Property p;
            try {
                p = (Property)this.resNode.getPrimaryItem();
            }
            catch (ItemNotFoundException e) {
                p = this.resNode.getProperty("jcr:data");
            }
            Binary bin = p.getBinary();
            this.usedBinaries.add(bin);
            return bin.getStream();
        }
        catch (RepositoryException e) {
            IOException io = new IOException(e.getMessage());
            io.initCause(e);
            throw io;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream not supported");
    }

    public String getContentType() {
        try {
            if (this.resNode.hasProperty("jcr:mimeType")) {
                return this.resNode.getProperty("jcr:mimeType").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return this.name;
    }
}

