/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.commons;

import com.day.cq.security.profile.Profile;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.text.StrLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileVariableLookup
extends StrLookup {
    public static final String AUTHORIZABLE_ID = "authorizableID";
    private static final Logger log = LoggerFactory.getLogger(ProfileVariableLookup.class);
    private final Map<String, String> overlay;
    private final Profile profile;
    private final Map<String, Method> map;

    public ProfileVariableLookup(Profile profile) throws IntrospectionException {
        this(profile, new HashMap<String, String>());
    }

    public ProfileVariableLookup(Profile profile, Map<String, String> overlays) throws IntrospectionException {
        this.profile = profile;
        this.map = new HashMap<String, Method>();
        for (PropertyDescriptor propDesc : Introspector.getBeanInfo(profile.getClass(), 3).getPropertyDescriptors()) {
            if (!propDesc.getPropertyType().isAssignableFrom(String.class)) continue;
            this.map.put(propDesc.getName(), propDesc.getReadMethod());
        }
        if (profile.getAuthorizable() != null) {
            Node authNode = (Node)profile.getAuthorizable().adaptTo(Node.class);
            try {
                if (authNode != null && authNode.getIdentifier() != null) {
                    overlays.put("userUUID", authNode.getIdentifier());
                }
            }
            catch (RepositoryException re) {
                // empty catch block
            }
        }
        this.overlay = overlays;
    }

    public String lookup(String variable) {
        if (this.overlay.containsKey(variable)) {
            return this.overlay.get(variable);
        }
        if (AUTHORIZABLE_ID.equals(variable)) {
            return this.profile.getAuthorizable().getID();
        }
        if (this.profile.containsKey((Object)variable)) {
            return (String)this.profile.get(variable, String.class);
        }
        if (this.map.containsKey(variable)) {
            try {
                return (String)this.map.get(variable).invoke((Object)this.profile, new Object[0]);
            }
            catch (IllegalAccessException e) {
                log.warn("Failed to access Profile Method for {}:{}", (Object)variable, (Object)e);
            }
            catch (InvocationTargetException e) {
                log.warn("Failed to access Profile Method for {}:{}", (Object)variable, (Object)e);
            }
        }
        return null;
    }

    public void put(String var, String replace) {
        this.overlay.put(var, replace);
    }
}

