/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailingStatus;
import com.day.cq.mailer.MailingStatusCode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CqMailingStatus
implements MailingStatus {
    MailingStatusCode code = MailingStatusCode.NEW;
    private static final Logger log = LoggerFactory.getLogger(CqMailingStatus.class);
    private final ArrayList<String> errors = new ArrayList();
    private HashSet<CqMailingStatus> recipients = new HashSet();
    private long sent = 0L;
    private final String path;
    private Date lastModification;

    CqMailingStatus(String path, Date date) {
        this.path = path;
        this.lastModification = date;
    }

    CqMailingStatus(String path) {
        this(path, new Date());
    }

    @Override
    public String getMailingID() {
        return this.getPath();
    }

    @Override
    public boolean isSent() {
        try {
            MailingStatusCode code = this.getStatusCode();
            return MailingStatusCode.SENT == code;
        }
        catch (RepositoryException e) {
            log.debug("Failed to access status code {}", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isNew() {
        try {
            MailingStatusCode code = this.getStatusCode();
            return MailingStatusCode.NEW == code;
        }
        catch (RepositoryException e) {
            log.debug("Failed to access status code {}", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean hasError() {
        try {
            MailingStatusCode code = this.getStatusCode();
            return code.isError();
        }
        catch (RepositoryException e) {
            log.debug("Failed to access status code {}", (Throwable)e);
            return false;
        }
    }

    @Override
    public long numSent() {
        return this.sent;
    }

    @Override
    public Date getLastModified() {
        return this.lastModification;
    }

    @Override
    public MailingStatusCode getStatusCode() throws RepositoryException {
        return this.code;
    }

    protected void setStatus(MailingStatusCode code) throws RepositoryException {
        this.code = code;
        this.timestamp();
    }

    protected void setSent() throws RepositoryException {
        this.setStatus(MailingStatusCode.SENT);
    }

    protected void setError(Exception e) throws RepositoryException {
        this.setStatus(MailingStatusCode.ERROR);
        this.addErrorMessage(e.getMessage());
    }

    protected void addRecipient(CqMailingStatus recipient) {
        this.recipients.add(recipient);
        if (recipient.isSent()) {
            this.addSent();
        }
    }

    protected void addSent() {
        ++this.sent;
    }

    protected Collection<CqMailingStatus> getRecipients() {
        return this.recipients;
    }

    String getPath() {
        return this.path;
    }

    Collection<String> getErrorMessages() {
        return Collections.unmodifiableCollection(this.errors);
    }

    void setErrors(Value[] vals) throws RepositoryException {
        for (Value val : vals) {
            this.errors.add(val.getString());
        }
    }

    void setLastModified(Calendar date) {
        this.lastModification = date.getTime();
    }

    private void addErrorMessage(String message) throws RepositoryException {
        this.errors.add(message);
    }

    private void timestamp() {
        this.lastModification = new Date();
    }
}

