/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.mailer.email.RetrieverEmailTemplateFactory;
import com.day.cq.mailer.impl.email.CqRetrieverEMailTemplate;
import com.day.cq.retriever.RetrieverService;
import java.net.URI;
import java.nio.charset.Charset;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.mail.HtmlEmail;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqRetrieverTemplateFactory
implements RetrieverEmailTemplateFactory<HtmlEmail> {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final boolean DEFAULT_EMBED = false;
    private RetrieverService retriever;
    static String PROP_EMBED_RESOURCES = "mailer.email.embed";
    static String PROP_CHAR_SET = "mailer.email.charset";
    static final String PROP_RET_UID = "mailer.email.retrieverUserID";
    static final String PROP_RET_PWD = "mailer.email.retrieverUserPWD";
    private Charset charSet = Charset.forName("UTF-8");
    private UsernamePasswordCredentials retrieverCredentials;
    private boolean embedResources = false;

    public CqRetrieverEMailTemplate create(URI uri) throws RepositoryException {
        CqRetrieverEMailTemplate tmpl = new CqRetrieverEMailTemplate(uri, this.retriever, (Credentials)this.retrieverCredentials);
        tmpl.embedResources(this.embedResources);
        tmpl.setCharSet(this.charSet);
        return tmpl;
    }

    protected void activate(ComponentContext ctx) {
        this.charSet = Charset.forName((String)ctx.getProperties().get(PROP_CHAR_SET));
        this.embedResources = OsgiUtil.toBoolean(ctx.getProperties().get(PROP_EMBED_RESOURCES), (boolean)false);
        String retrieverUID = OsgiUtil.toString(ctx.getProperties().get(PROP_RET_UID), (String)"admin");
        String retrieverPWD = OsgiUtil.toString(ctx.getProperties().get(PROP_RET_PWD), (String)"admin");
        if (retrieverUID != null && retrieverPWD != null) {
            this.retrieverCredentials = new UsernamePasswordCredentials(retrieverUID, retrieverPWD);
        }
    }

    protected void bindRetrieverService(RetrieverService service) {
        this.retriever = service;
    }

    protected void unbindRetriever(RetrieverService retrieverService) {
        if (this.retriever == retrieverService) {
            this.retriever = null;
        }
    }
}

