/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl;

import com.day.cq.mailer.MailService;
import com.day.cq.mailer.MailingException;
import com.day.cq.mailer.MessageGateway;
import java.util.Dictionary;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="%mail.service.name", description="%mail.service.description", name="com.day.cq.mailer.DefaultMailService", immediate=true, metatype=true)
public class DefaultMailService
implements MessageGateway<Email>,
MailService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMailService.class);
    private static final String DEFAULT_SMTP_HOST = "";
    private static final int DEFAULT_SMTP_PORT = 25;
    private static final boolean DEFAULT_DEBUG_EMAIL = false;
    private static final boolean DEFAULT_USE_SSL_CONNECTION = false;
    @Property(value={""})
    private static final String SMTP_HOST = "smtp.host";
    @Property(intValue={25})
    private static final String SMTP_PORT = "smtp.port";
    @Property
    private static final String SMTP_USER = "smtp.user";
    @Property
    private static final String SMTP_PASSWORD = "smtp.password";
    @Property
    private static final String FROM_ADDRESS = "from.address";
    @Property(boolValue={false})
    private static final String SMTP_SSL = "smtp.ssl";
    @Property(boolValue={false})
    private static final String DEBUG_EMAIL = "debug.email";
    volatile Cfg cfg;
    private ServiceRegistration serviceRegistration;

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        Cfg newCfg = new Cfg(properties);
        if (newCfg.isValidConfig()) {
            this.cfg = newCfg;
            if (null != this.serviceRegistration) {
                this.serviceRegistration.setProperties(properties);
            } else {
                this.serviceRegistration = componentContext.getBundleContext().registerService(new String[]{MailService.class.getName(), MessageGateway.class.getName()}, (Object)this, properties);
            }
            if (log.isDebugEnabled()) {
                log.debug("MailService activated, fromAddress={}, smtpHost={}, smtpPort={}, debugEmail={}, smtpUser={}.", new Object[]{this.cfg.fromAddress, this.cfg.smtpHost, this.cfg.smtpPort, this.cfg.debugEmail, this.cfg.smtpUser == null ? DEFAULT_SMTP_HOST : this.cfg.smtpUser});
            }
        } else {
            log.error("Invalid mail service configuration.");
            this.unregister();
        }
    }

    @Deactivate
    private void unregister() {
        if (null != this.serviceRegistration) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        this.cfg = null;
    }

    @Override
    public void sendEmail(Email email) throws EmailException {
        this.send(email);
    }

    @Override
    public boolean handles(Class type) {
        return Email.class.isAssignableFrom(type);
    }

    @Override
    public void send(Email email) throws MailingException {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            boolean hasHostName;
            Cfg cfg = this.cfg;
            if (null == cfg) {
                throw new MailingException("Invalid mail service configuration.");
            }
            email.setDebug(cfg.debugEmail);
            if (email.getFromAddress() == null) {
                if (cfg.fromAddress == null || cfg.fromAddress.trim().length() == 0) {
                    throw new EmailException("no from-address was given, cannot send message");
                }
                email.setFrom(cfg.fromAddress);
            }
            boolean bl = hasHostName = null != email.getHostName();
            if (!hasHostName) {
                email.setHostName(cfg.smtpHost);
                if (cfg.smtpSsl) {
                    email.setSSL(true);
                    email.setSslSmtpPort(String.valueOf(cfg.smtpPort));
                } else {
                    email.setSmtpPort(cfg.smtpPort);
                }
                if (cfg.smtpUser != null && cfg.smtpUser.trim().length() > 0) {
                    email.setAuthentication(cfg.smtpUser, cfg.smtpPassword);
                }
            }
            email.send();
        }
        catch (EmailException e) {
            throw new MailingException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Cfg {
        final String smtpHost;
        final int smtpPort;
        final String smtpUser;
        final String smtpPassword;
        final String fromAddress;
        final boolean debugEmail;
        final boolean smtpSsl;

        Cfg(Dictionary<String, Object> properties) {
            this.smtpHost = OsgiUtil.toString((Object)properties.get(DefaultMailService.SMTP_HOST), (String)DefaultMailService.DEFAULT_SMTP_HOST);
            this.smtpPort = OsgiUtil.toInteger((Object)properties.get(DefaultMailService.SMTP_PORT), (int)25);
            this.smtpUser = OsgiUtil.toString((Object)properties.get(DefaultMailService.SMTP_USER), null);
            this.smtpPassword = OsgiUtil.toString((Object)properties.get(DefaultMailService.SMTP_PASSWORD), null);
            this.fromAddress = (String)properties.get(DefaultMailService.FROM_ADDRESS);
            this.debugEmail = OsgiUtil.toBoolean((Object)properties.get(DefaultMailService.DEBUG_EMAIL), (boolean)false);
            this.smtpSsl = OsgiUtil.toBoolean((Object)properties.get(DefaultMailService.SMTP_SSL), (boolean)false);
        }

        public Cfg(String smtpHost, int smtpPort, String fromAddress, boolean debugEmail, String smtpUser, String smtpPassword, boolean smtpSsl) {
            this.smtpHost = smtpHost;
            this.smtpPort = smtpPort;
            this.fromAddress = fromAddress;
            this.debugEmail = debugEmail;
            this.smtpUser = smtpUser;
            this.smtpPassword = smtpPassword;
            this.smtpSsl = smtpSsl;
        }

        boolean isValidConfig() {
            if (this.smtpPort < 25) {
                log.error("invalid configuration: SMTP port must be 25 or greater.");
                return false;
            }
            if (StringUtils.isBlank((String)this.smtpHost)) {
                log.error("invalid configuration: SMTP host must not be blank.");
                return false;
            }
            return true;
        }
    }
}

