/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.mailer.MailingException;
import com.day.cq.mailer.commons.ProfileVariableLookup;
import com.day.cq.mailer.commons.ProfileVariableSubstitutor;
import com.day.cq.mailer.email.EmailTemplate;
import com.day.cq.mailer.impl.email.ResourceDataSource;
import com.day.cq.security.profile.Profile;
import java.beans.IntrospectionException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.RepositoryException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmailTemplate<Type extends MultiPartEmail>
implements EmailTemplate<Type> {
    private final ArrayList<DataSource> attachments = new ArrayList();
    private final Map<String, String> variables = new HashMap<String, String>();
    private InternetAddress from;
    private String text;
    private Charset charSet;
    private String subject;
    private boolean disposed;

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setFrom(InternetAddress from) throws AddressException {
        from.validate();
        this.from = from;
    }

    @Override
    public InternetAddress getFrom() {
        return this.from;
    }

    @Override
    public void setCharSet(Charset charSet) {
        this.charSet = charSet;
    }

    @Override
    public Charset getCharSet() {
        return this.charSet;
    }

    public void addAttachment(DataSource dataSource) {
        this.attachments.add(dataSource);
    }

    @Override
    public Type buildMessage(Profile profile) throws MailingException {
        if (this.isDisposed()) {
            throw new IllegalStateException("Template already disposed recreate from MessageTemplateFactory");
        }
        if (profile.getPrimaryMail() != null) {
            try {
                MultiPartEmail mail = (MultiPartEmail)this.getType().newInstance();
                ProfileVariableLookup vr = new ProfileVariableLookup(profile, this.variables);
                mail = this.build(mail, profile, vr);
                this.doBuild(mail, profile, vr);
                return (Type)mail;
            }
            catch (EmailException e) {
                return null;
            }
            catch (RepositoryException e) {
                throw new MailingException(e);
            }
            catch (IllegalAccessException e) {
                throw new MailingException(e);
            }
            catch (InstantiationException e) {
                throw new MailingException(e);
            }
            catch (IntrospectionException e) {
                throw new MailingException(e);
            }
            catch (Exception e) {
                throw new MailingException(e);
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            for (DataSource src : this.attachments) {
                if (!(src instanceof ResourceDataSource)) continue;
                ((ResourceDataSource)src).dispose();
            }
        }
        this.disposed = true;
    }

    protected abstract Type doBuild(Type var1, Profile var2, ProfileVariableLookup var3) throws RepositoryException, EmailException;

    protected boolean isDisposed() {
        return this.disposed;
    }

    private Type build(Type mail, Profile recipient, StrLookup sub) throws RepositoryException, EmailException {
        mail.addTo(recipient.getPrimaryMail());
        if (this.from != null) {
            mail.setFrom(this.from.getAddress());
        }
        if (this.charSet != null) {
            mail.setCharset(this.charSet.name());
        }
        if (this.subject != null) {
            mail.setSubject(new ProfileVariableSubstitutor(sub).replace(this.subject, true));
        }
        if (this.attachments.size() > 0) {
            for (DataSource ds : this.attachments) {
                mail.attach(ds, ds.getName(), ds.getName());
            }
        }
        return mail;
    }

    @Override
    public void put(String var, String replace) {
        this.variables.put(var, replace);
    }
}

