/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.mailer.commons.ProfileVariableLookup;
import com.day.cq.mailer.commons.ProfileVariableSubstitutor;
import com.day.cq.mailer.impl.email.AbstractEmailTemplate;
import com.day.cq.mailer.impl.email.ResourceDataSource;
import com.day.cq.retriever.RetrieverService;
import com.day.cq.retriever.RetrieverStorage;
import com.day.cq.security.profile.Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqRetrieverEMailTemplate
extends AbstractEmailTemplate<HtmlEmail>
implements RetrieverStorage {
    static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    private static final Logger log = LoggerFactory.getLogger(CqRetrieverEMailTemplate.class);
    private static final String[] PATH_CHAR = JcrUtil.STANDARD_LABEL_CHAR_MAPPING;
    private String html;
    private URI uri;
    private final HashMap<String, DataSource> embed;
    private final RetrieverService retriever;
    private final Credentials credentials;
    private int resCounter;
    private boolean embedResources = false;
    private boolean disposed = false;

    CqRetrieverEMailTemplate(URI uri, RetrieverService retriever, Credentials credentials) throws RepositoryException {
        this.retriever = retriever;
        this.credentials = credentials;
        this.embed = new HashMap();
        this.uri = uri;
    }

    public void embedResources(boolean embedResources) {
        this.embedResources = embedResources;
    }

    public String getHtml() {
        if (this.html == null && this.uri != null) {
            try {
                this.retrieve();
            }
            catch (Exception e) {
                log.error("Failed to retrieve Content {}", (Throwable)e);
            }
        }
        return this.html;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
        this.setHtml(null);
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public boolean addEmbedded(String name, DataSource data) {
        return this.embed.put(name, data) == null;
    }

    @Override
    public Class<HtmlEmail> getType() {
        return HtmlEmail.class;
    }

    @Override
    protected HtmlEmail doBuild(HtmlEmail mail, Profile recipient, ProfileVariableLookup vr) throws EmailException, RepositoryException {
        String htmlStr = this.getHtml();
        for (Map.Entry<String, DataSource> entry : this.embed.entrySet()) {
            DataSource res = entry.getValue();
            String ref = mail.embed(res, res.getName(), res.getName());
            vr.put(entry.getKey(), ref);
            vr.put("file#" + entry.getKey(), ref);
        }
        String html = new ProfileVariableSubstitutor(vr).replace(htmlStr, true);
        mail.setHtmlMsg(html);
        if (this.getText() != null) {
            mail.setTextMsg(this.getText());
        }
        return mail;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            for (DataSource src : this.embed.values()) {
                if (!(src instanceof ResourceDataSource)) continue;
                ((ResourceDataSource)src).dispose();
            }
            this.disposed = true;
        }
    }

    public void storeContent(String content) throws IOException {
        this.setHtml(content);
    }

    public String maybeDownloadResource(String elementName, String attributeName, String resourceUri, Attributes attributes) throws IOException {
        if (!this.embedResources) {
            return null;
        }
        String result = null;
        InputStream is = null;
        String mimeType = null;
        try {
            GetMethod m = new GetMethod(resourceUri);
            m.setDoAuthentication(this.credentials != null);
            HttpClient client = new HttpClient();
            client.getState().setCredentials(new AuthScope(null, -1, null), this.credentials);
            client.getParams().setAuthenticationPreemptive(true);
            client.executeMethod((HttpMethod)m);
            if (m.getStatusCode() >= 200 && m.getStatusCode() < 300 || m.getStatusCode() == 304) {
                mimeType = m.getResponseHeader("Content-Type").getValue() == null ? DEFAULT_CONTENT_TYPE : m.getResponseHeader("Content-Type").getValue();
                is = m.getResponseBodyAsStream();
            } else {
                if (m.getStatusCode() == 404) {
                    log.debug("Resource not found {}", (Object)resourceUri);
                    return null;
                }
                if (m.getStatusCode() >= 400 && m.getStatusCode() < 500) {
                    log.debug("Unauthorized to download {} with credentials: {} ", (Object)resourceUri, (Object)m.getStatusCode());
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.info("Retrieval of resource " + resourceUri + " failed: " + e);
            return result;
        }
        int lastSlash = resourceUri.lastIndexOf(47);
        final String name = JcrUtil.createValidName((String)(++this.resCounter + "_" + (lastSlash >= 0 ? resourceUri.substring(lastSlash + 1) : resourceUri)), (String[])PATH_CHAR);
        final byte[] ba = IOUtils.toByteArray((InputStream)is);
        final String contentType = mimeType;
        log.debug("Downloading resource {}, storing with filename={}", (Object)resourceUri, (Object)name);
        try {
            result = this.storeResource(new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(ba);
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("Outputstream not available on post");
                }

                public String getContentType() {
                    return contentType;
                }

                public String getName() {
                    return name;
                }
            });
        }
        catch (RepositoryException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        return result;
    }

    public String storeResource(DataSource source) throws IOException, RepositoryException {
        String name = String.format("cid:%1$s", source.getName());
        this.embed.put(name, source);
        return name;
    }

    private void retrieve() throws Exception {
        if (this.uri != null && this.html == null) {
            String baseUri = this.uri.resolve("/").toString();
            if (baseUri.endsWith("/")) {
                baseUri = baseUri.substring(0, baseUri.length() - 1);
            }
            this.retriever.retrieve(this.uri.toString(), baseUri, (RetrieverStorage)this);
        }
    }

    static {
        CqRetrieverEMailTemplate.PATH_CHAR[46] = ".";
    }
}

