/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.impl.email;

import com.day.cq.mailer.MailingException;
import com.day.cq.mailer.MessageTemplate;
import com.day.cq.mailer.commons.ProfileVariableLookup;
import com.day.cq.security.profile.Profile;
import java.beans.IntrospectionException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email2SMSMessageTemplateFactory {
    public static final String DEFAULT_TYPE = "Email2SMS";
    static final String PROP_TEXT = "text";
    static final String PROP_SMS = "sms";
    static final String PATH_TEMPLATE = "template";
    static final String NUMBER_TYPE_DEFAULT = "mobile";
    private static final String TYPE_PROPERTY = "type";
    private static final String VALUE_PROPERTY = "value";
    protected static final String[] TYPE = new String[]{"Email2SMS"};
    @Property(label="%mailer.mail2sms.to", description="%mailer.mail2sms.to.description")
    protected static final String TO_PROP = "mailer.mail2sms.to";
    @Property(label="%mailer.mail2sms.from", description="%mailer.mail2sms.from.description")
    protected static final String FROM_PROP = "mailer.mail2sms.from";
    @Property(value={"mobile"}, label="%mailer.mail2sms.numberType", description="%mailer.mail2sms.numberType.description")
    protected static final String NUMBER_TYPE_PROP = "mailer.mail2sms.numberType";
    private String numberType;
    private String from;
    private String to;
    private static final Logger log = LoggerFactory.getLogger(Email2SMSMessageTemplateFactory.class);

    public Class<Email> getMessageType() {
        return Email.class;
    }

    public boolean handles(Resource resource) throws RepositoryException {
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null || !node.hasNode("jcr:content")) {
            return false;
        }
        return (node = node.getNode("jcr:content")).hasProperty(PROP_SMS) || node.hasProperty(PROP_TEXT);
    }

    public SMSMessageTemplate create(Resource resource) throws RepositoryException {
        if (this.handles(resource)) {
            return this.create((Node)resource.adaptTo(Node.class));
        }
        return null;
    }

    public SMSMessageTemplate create(Node node) throws RepositoryException {
        return new SMSMessageTemplate(node);
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        String savedTo = OsgiUtil.toString(props.get(TO_PROP), null);
        if (StringUtils.isBlank((String)savedTo)) {
            log.error("Component Configuration misses required property {}: cant activate", (Object)TO_PROP);
            throw new ComponentException("Missing required property mailer.mail2sms.to");
        }
        this.to = savedTo.trim();
        this.from = StringUtils.isBlank((String)OsgiUtil.toString(props.get(FROM_PROP), null)) ? null : OsgiUtil.toString(props.get(FROM_PROP), null).trim();
        this.numberType = OsgiUtil.toString(props.get(NUMBER_TYPE_PROP), (String)NUMBER_TYPE_DEFAULT).trim();
        if (log.isDebugEnabled()) {
            log.debug("Configured {} with the following values:", props.get("component.name"));
            log.debug("{} : {}", (Object)TO_PROP, (Object)this.to);
            log.debug("{} : {}", (Object)FROM_PROP, (Object)this.from);
            log.debug("{} : {}", (Object)NUMBER_TYPE_PROP, (Object)this.numberType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SMSMessageTemplate
    implements MessageTemplate<Email> {
        private final Map<String, String> variables = new HashMap<String, String>();
        private String message;
        private Node content;
        private boolean changed;

        SMSMessageTemplate(Node template) throws RepositoryException {
            this.content = template.getNode("jcr:content");
            if (this.content.hasProperty(Email2SMSMessageTemplateFactory.PROP_SMS)) {
                this.message = this.content.getProperty(Email2SMSMessageTemplateFactory.PROP_SMS).getString();
            } else if (this.content.hasProperty(Email2SMSMessageTemplateFactory.PROP_TEXT)) {
                this.message = this.content.getProperty(Email2SMSMessageTemplateFactory.PROP_TEXT).getString();
            }
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.changed = true;
            this.message = message;
        }

        @Override
        public Class<Email> getType() {
            return Email.class;
        }

        @Override
        public Email buildMessage(Profile profile) throws MailingException {
            Iterator iterator = profile.getPhoneNumbers();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                ValueMap map = (ValueMap)resource.adaptTo(ValueMap.class);
                String number = null;
                if (map != null && Email2SMSMessageTemplateFactory.this.numberType.equals(map.get(Email2SMSMessageTemplateFactory.TYPE_PROPERTY, String.class))) {
                    number = (String)map.get(Email2SMSMessageTemplateFactory.VALUE_PROPERTY, String.class);
                }
                if (number == null) continue;
                log.debug("Found no Number of type {} for {}, build", (Object)Email2SMSMessageTemplateFactory.this.numberType, (Object)profile.getFormattedName());
                try {
                    ProfileVariableLookup vr = new ProfileVariableLookup(profile, this.variables);
                    SimpleEmail mail = new SimpleEmail();
                    mail.addTo(Email2SMSMessageTemplateFactory.this.to);
                    mail.setSubject(number);
                    mail.setMsg(new StrSubstitutor((StrLookup)vr).replace(this.message));
                    if (Email2SMSMessageTemplateFactory.this.from != null) {
                        mail.setFrom(Email2SMSMessageTemplateFactory.this.from);
                    }
                    return mail;
                }
                catch (EmailException e) {
                    throw new MailingException(e);
                }
                catch (IntrospectionException e) {
                    throw new MailingException(e);
                }
            }
            log.debug("Found no Number of type {} for {}: ignore", (Object)Email2SMSMessageTemplateFactory.this.numberType, (Object)profile.getFormattedName());
            return null;
        }

        @Override
        public void dispose() throws MailingException {
        }

        @Override
        public void put(String var, String replace) {
            this.variables.put(var, replace);
        }
    }
}

