/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.adobe.granite.security.user.UserProperties;
import com.day.cq.personalization.ProfileProvider;
import com.day.cq.personalization.UserPropertiesProvider;
import com.day.cq.security.profile.Profile;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Property(name="service.description", value={"%profileadapterfactory.name"})
public class ProfileAdapterFactory
implements AdapterFactory {
    private final Logger log = LoggerFactory.getLogger(ProfileAdapterFactory.class);
    private static final String REQUEST_ATTRIBUTE_NAME_PROFILE = Profile.class.getName();
    private static final String REQUEST_ATTRIBUTE_NAME_USERPROPERTIES = UserProperties.class.getName();
    private ProfileProviderServiceTracker serviceTracker;
    private UserPropertiesProviderServiceTracker userPropsServiceTracker;
    private Map<ServiceReference, ProfileProvider> providerCache = new TreeMap<ServiceReference, ProfileProvider>();
    private Map<ServiceReference, UserPropertiesProvider> userPropsProviderCache = new TreeMap<ServiceReference, UserPropertiesProvider>();
    private static final Class<Profile> PROFILE_CLASS = Profile.class;
    private static final Class<UserProperties> USERPROPERTIES_CLASS = UserProperties.class;
    @Property(name="adapters")
    public static final String[] ADAPTER_CLASSES = new String[]{PROFILE_CLASS.getName(), USERPROPERTIES_CLASS.getName()};
    @Property(name="adaptables")
    public static final String[] ADAPTABLE_CLASSES = new String[]{ResourceResolver.class.getName(), SlingHttpServletRequest.class.getName()};

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        if (adaptable instanceof ResourceResolver) {
            return this.getAdapter((ResourceResolver)adaptable, type);
        }
        if (adaptable instanceof SlingHttpServletRequest) {
            return this.getAdapter((SlingHttpServletRequest)adaptable, type);
        }
        this.log.warn("Unable to handle adaptable [{}]", (Object)adaptable.getClass().getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(ResourceResolver resolver, Class<AdapterType> type) {
        if (PROFILE_CLASS == type) {
            return (AdapterType)this.getProfile(resolver);
        }
        if (USERPROPERTIES_CLASS == type) {
            return (AdapterType)this.getUserProperties(resolver);
        }
        this.log.debug("Unable to adapt resolver [{}] to type [{}]", (Object)resolver, (Object)type.getName());
        return null;
    }

    private <AdapterType> AdapterType getAdapter(SlingHttpServletRequest request, Class<AdapterType> type) {
        if (PROFILE_CLASS == type) {
            return (AdapterType)this.getProfile(request);
        }
        if (USERPROPERTIES_CLASS == type) {
            return (AdapterType)this.getUserProperties(request);
        }
        this.log.debug("Unable to adapt request [{}] to type [{}]", (Object)request.getRequestURI(), (Object)type.getName());
        return null;
    }

    public Profile getProfile(SlingHttpServletRequest request) {
        Profile profile = (Profile)request.getAttribute(REQUEST_ATTRIBUTE_NAME_PROFILE);
        Iterator<ProfileProvider> providers = this.providerCache.values().iterator();
        while (null == profile && providers.hasNext()) {
            ProfileProvider provider = providers.next();
            this.log.debug("asking provider [{}] for profile on [{}]...", (Object)provider, (Object)request.getRequestURI());
            profile = provider.getProfile(request);
            if (profile == null) continue;
            this.log.debug("provider [{}] returned profile [{}].", (Object)provider, (Object)profile);
            request.setAttribute(REQUEST_ATTRIBUTE_NAME_PROFILE, (Object)profile);
        }
        return profile;
    }

    public Profile getProfile(ResourceResolver resolver) {
        Profile profile = null;
        Iterator<ProfileProvider> providers = this.providerCache.values().iterator();
        while (null == profile && providers.hasNext()) {
            ProfileProvider provider = providers.next();
            this.log.debug("asking provider [{}] for profile on [{}]...", (Object)provider, (Object)resolver);
            profile = provider.getProfile(resolver);
            if (profile == null) continue;
            this.log.debug("provider [{}] returned profile [{}].", (Object)provider, (Object)profile);
        }
        return profile;
    }

    public UserProperties getUserProperties(SlingHttpServletRequest request) {
        UserProperties userProperties = (UserProperties)request.getAttribute(REQUEST_ATTRIBUTE_NAME_USERPROPERTIES);
        Iterator<UserPropertiesProvider> providers = this.userPropsProviderCache.values().iterator();
        while (null == userProperties && providers.hasNext()) {
            UserPropertiesProvider provider = providers.next();
            this.log.debug("asking provider [{}] for userProperties on [{}]...", (Object)provider, (Object)request.getRequestURI());
            userProperties = provider.getUserProperties(request);
            if (userProperties == null) continue;
            this.log.debug("provider [{}] returned userProperties [{}].", (Object)provider, (Object)userProperties);
            request.setAttribute(REQUEST_ATTRIBUTE_NAME_USERPROPERTIES, (Object)userProperties);
        }
        return userProperties;
    }

    public UserProperties getUserProperties(ResourceResolver resolver) {
        UserProperties userProperties = null;
        Iterator<UserPropertiesProvider> providers = this.userPropsProviderCache.values().iterator();
        while (null == userProperties && providers.hasNext()) {
            UserPropertiesProvider provider = providers.next();
            this.log.debug("asking provider [{}] for userProperties on [{}]...", (Object)provider, (Object)resolver);
            userProperties = provider.getUserProperties(resolver);
            if (userProperties == null) continue;
            this.log.debug("provider [{}] returned userProperties [{}].", (Object)provider, (Object)userProperties);
        }
        return userProperties;
    }

    protected void activate(ComponentContext context) {
        BundleContext bundleContext = context.getBundleContext();
        this.serviceTracker = new ProfileProviderServiceTracker(bundleContext, ProfileProvider.class.getName(), this.providerCache);
        this.serviceTracker.open();
        this.userPropsServiceTracker = new UserPropertiesProviderServiceTracker(bundleContext, UserPropertiesProvider.class.getName(), this.userPropsProviderCache);
        this.userPropsServiceTracker.open();
    }

    protected void deactivate(ComponentContext context) {
        this.serviceTracker.close();
        this.userPropsServiceTracker.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UserPropertiesProviderServiceTracker
    extends ServiceTracker {
        final Map<ServiceReference, UserPropertiesProvider> serviceCache;

        UserPropertiesProviderServiceTracker(BundleContext context, String clazz, Map<ServiceReference, UserPropertiesProvider> serviceCache) {
            super(context, clazz, null);
            this.serviceCache = serviceCache;
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (null != service) {
                this.bindService(reference, service);
            }
            return service;
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.unbindService(reference);
            if (null != service) {
                this.bindService(reference, service);
            }
        }

        public void removedService(ServiceReference reference, Object service) {
            this.unbindService(reference);
            super.removedService(reference, service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bindService(ServiceReference reference, Object service) {
            Map<ServiceReference, UserPropertiesProvider> map = this.serviceCache;
            synchronized (map) {
                this.serviceCache.put(reference, (UserPropertiesProvider)service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unbindService(ServiceReference reference) {
            Map<ServiceReference, UserPropertiesProvider> map = this.serviceCache;
            synchronized (map) {
                this.serviceCache.remove(reference);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    static final class ProfileProviderServiceTracker
    extends ServiceTracker {
        final Map<ServiceReference, ProfileProvider> serviceCache;

        ProfileProviderServiceTracker(BundleContext context, String clazz, Map<ServiceReference, ProfileProvider> serviceCache) {
            super(context, clazz, null);
            this.serviceCache = serviceCache;
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (null != service) {
                this.bindService(reference, service);
            }
            return service;
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.unbindService(reference);
            if (null != service) {
                this.bindService(reference, service);
            }
        }

        public void removedService(ServiceReference reference, Object service) {
            this.unbindService(reference);
            super.removedService(reference, service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bindService(ServiceReference reference, Object service) {
            Map<ServiceReference, ProfileProvider> map = this.serviceCache;
            synchronized (map) {
                this.serviceCache.put(reference, (ProfileProvider)service);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unbindService(ServiceReference reference) {
            Map<ServiceReference, ProfileProvider> map = this.serviceCache;
            synchronized (map) {
                this.serviceCache.remove(reference);
            }
        }
    }
}

