/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.day.cq.commons.jcr.JcrUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="sling.servlet.selectors", value={"target", "untarget"}), @Property(name="sling.servlet.extensions", value={"json"})})
public class TargetServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(TargetServlet.class);
    public static final String TARGET_COMPONENT = "cq/personalization/components/target";
    public static final String DEFAULT_NODE = "default";
    public static final String TARGET_SELECTOR = "target";
    public static final String UNTARGET_SELECTOR = "untarget";
    public static final String RT_PARAM = "resourceType";

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        boolean revert = TargetServlet.hasSelector(request.getRequestPathInfo(), UNTARGET_SELECTOR);
        Resource resource = request.getResource();
        boolean success = true;
        try {
            Node node = (Node)resource.adaptTo(Node.class);
            if (revert) {
                if (node != null) {
                    this.untarget(node);
                } else {
                    this.log.warn("Cannot disable targeting for a non existing JCR path: " + resource.getPath());
                    success = false;
                }
            } else if (node != null) {
                this.target(node);
            } else {
                String rt = request.getParameter(RT_PARAM);
                if (rt != null) {
                    String path = this.getNonExistingPath(resource.getPath());
                    if (path != null) {
                        this.targetMissing(path, rt, (Session)request.getResourceResolver().adaptTo(Session.class));
                    } else {
                        this.log.warn("Cannot target missing node: " + resource.getPath());
                        success = false;
                    }
                } else {
                    this.log.warn("Cannot target missing node with no resourceType request parameter given: " + resource.getPath());
                    success = false;
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error("Cannot " + (revert ? "disable targeting" : TARGET_SELECTOR) + ": " + resource.getPath(), (Throwable)e);
            success = false;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONWriter writer = new JSONWriter((Writer)out);
        try {
            writer.object();
            writer.key("success").value(success);
            writer.endObject();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void target(Node component) throws RepositoryException {
        String name = component.getName();
        Node parent = component.getParent();
        Session session = component.getSession();
        String nodeAfter = TargetServlet.getNodeAfter(component);
        String tmpNodePath = TargetServlet.moveToTempNode(component, parent);
        Node newNode = parent.addNode(name);
        newNode.setProperty("sling:resourceType", TARGET_COMPONENT);
        parent.orderBefore(name, nodeAfter);
        session.move(tmpNodePath, newNode.getPath() + "/" + DEFAULT_NODE);
        session.save();
    }

    private void targetMissing(String path, String resourceType, Session session) throws RepositoryException {
        Node node = JcrUtil.createPath((String)path, (String)"nt:unstructured", (Session)session);
        node.setProperty("sling:resourceType", TARGET_COMPONENT);
        Node defaultNode = node.addNode(DEFAULT_NODE);
        defaultNode.setProperty("sling:resourceType", resourceType);
        session.save();
    }

    private void untarget(Node component) throws RepositoryException {
        if (!component.hasNode(DEFAULT_NODE) && !(component = component.getParent()).hasNode(DEFAULT_NODE)) {
            return;
        }
        String name = component.getName();
        Node wrappedComponent = component.getNode(DEFAULT_NODE);
        Node parent = component.getParent();
        Session session = component.getSession();
        String nodeAfter = TargetServlet.getNodeAfter(component);
        String tmpNodePath = TargetServlet.moveToTempNode(wrappedComponent, parent);
        String path = component.getPath();
        component.remove();
        session.move(tmpNodePath, path);
        parent.orderBefore(name, nodeAfter);
        session.save();
    }

    public static String getNodeAfter(Node node) throws RepositoryException {
        NodeIterator nodes = node.getParent().getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            if (!n.isSame((Item)node)) continue;
            if (nodes.hasNext()) {
                return nodes.nextNode().getName();
            }
            return null;
        }
        throw new RepositoryException("Could not find node in getParent().getNodes(): " + node.getPath());
    }

    public static String moveToTempNode(Node node, Node parent) throws RepositoryException {
        String tmpName = node.getName() + "_tmp_" + System.currentTimeMillis();
        String tmpNodePath = parent.getPath() + "/" + tmpName;
        node.getSession().move(node.getPath(), tmpNodePath);
        return tmpNodePath;
    }

    public static boolean hasSelector(RequestPathInfo pathInfo, String selector) {
        for (String s : pathInfo.getSelectors()) {
            if (!s.equals(selector)) continue;
            return true;
        }
        return false;
    }

    private String getNonExistingPath(String path) {
        if (path == null) {
            return null;
        }
        int pos = path.lastIndexOf(".target.");
        if (pos <= 0) {
            return null;
        }
        return path.substring(0, pos);
    }
}

