/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.pin.impl;

import com.day.cq.auth.pin.Pin;
import com.day.cq.auth.pin.impl.PinImpl;
import com.day.cq.auth.pin.impl.PinManagerFactoryImpl;
import java.util.Dictionary;
import java.util.Properties;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.auth.spi.AuthenticationHandler;
import org.apache.sling.commons.auth.spi.AuthenticationInfo;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PinAuthenticationHandler
implements AuthenticationHandler {
    static final String PARAM_PIN = ":cqpin";
    static final String COOKIE_PIN = "cqpin";
    static final String PARAM_PIN_COOKIE = ":cqpincookie";
    static final String AUTH_TYPE = "PIN";
    static final String PROPERTY_TRUSTED_CREDENTIALS_ATTRIBUTE = "pin.trustedCredentialsAttribute";
    static final String DEFAULT_TRUSTED_CREDENTIALS_ATTRIBUTE = "TrustedInfo";
    static final String PROPERTY_HANDLER_ROOT = "pin.handler.root";
    static final String[] DEFAULT_HANDLER_ROOT = new String[]{"/content", "/var"};
    private static final String DESCRIPTION = "PIN Authentication Handler";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PinManagerFactoryImpl pinManager;
    private final String trustedAuthenticationAttributeName;
    private ServiceRegistration registration;

    PinAuthenticationHandler(BundleContext bundleContext, PinManagerFactoryImpl pinManager, Dictionary<?, ?> config) {
        this.pinManager = pinManager;
        this.trustedAuthenticationAttributeName = OsgiUtil.toString(config.get(PROPERTY_TRUSTED_CREDENTIALS_ATTRIBUTE), (String)DEFAULT_TRUSTED_CREDENTIALS_ATTRIBUTE);
        String[] handlerRootProp = OsgiUtil.toStringArray(config.get(PROPERTY_HANDLER_ROOT));
        if (handlerRootProp == null) {
            handlerRootProp = DEFAULT_HANDLER_ROOT;
        }
        Properties props = new Properties();
        props.put("service.description", DESCRIPTION);
        props.put("service.vendor", config.get("service.vendor"));
        props.put("path", handlerRootProp);
        this.registration = bundleContext.registerService(AuthenticationHandler.class.getName(), (Object)this, (Dictionary)props);
        this.log.warn("PIN Authentication has been deprecated for security reasons.");
    }

    void dispose() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        String pinId = this.getPin(request);
        if (pinId == null) {
            this.log.debug("authenticate: Request has no {} PIN value, cannot authenticate", (Object)PARAM_PIN);
            return null;
        }
        Pin pin = this.pinManager.getPinPrivileged(pinId);
        if (pin == null) {
            this.log.warn("authenticate: Unknown PIN {} used, cannot authenticate", (Object)pinId);
            return null;
        }
        if (pin instanceof PinImpl && ((PinImpl)pin).isValid(request)) {
            this.setPinCookie(request, response, pin);
            this.log.info("authenticate: PIN {} authenticates user {}", (Object)pinId, (Object)pin.getUserId());
            return this.createAuthenticationInfo(pin);
        }
        this.setPinCookie(request, response, null);
        this.log.warn("authenticate: PIN {} (owner: {}) has expired, cannot authenticate", (Object)pinId, (Object)pin.getUserId());
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.setPinCookie(request, response, null);
        return false;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.setPinCookie(request, response, null);
    }

    public String toString() {
        return DESCRIPTION;
    }

    private String getPin(HttpServletRequest request) {
        String pinParam = request.getParameter(PARAM_PIN);
        if (pinParam != null) {
            return pinParam;
        }
        Cookie pinCookie = this.getPinCookie(request);
        if (pinCookie != null) {
            return pinCookie.getValue();
        }
        return null;
    }

    private Cookie getPinCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_PIN.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    private void setPinCookie(HttpServletRequest request, HttpServletResponse response, Pin pin) {
        String value;
        int maxAge;
        String requestCookie = request.getParameter(PARAM_PIN_COOKIE);
        if (pin == null) {
            maxAge = 0;
            value = "-";
        } else {
            if (requestCookie == null) {
                return;
            }
            if ("true".equalsIgnoreCase(requestCookie)) {
                maxAge = -1;
                value = pin.getId();
            } else {
                maxAge = 0;
                value = "-";
            }
        }
        if (maxAge == 0 && this.getPinCookie(request) == null) {
            return;
        }
        Cookie pinCookie = new Cookie(COOKIE_PIN, value);
        pinCookie.setSecure(request.isSecure());
        pinCookie.setPath(request.getContextPath().length() == 0 ? "/" : request.getContextPath());
        pinCookie.setMaxAge(maxAge);
        response.addCookie(pinCookie);
    }

    private AuthenticationInfo createAuthenticationInfo(Pin pin) {
        SimpleCredentials credentials = new SimpleCredentials(pin.getUserId(), new char[0]);
        credentials.setAttribute(this.trustedAuthenticationAttributeName, (Object)this.trustedAuthenticationAttributeName);
        AuthenticationInfo authInfo = new AuthenticationInfo(AUTH_TYPE);
        authInfo.put("user.jcr.credentials", (Object)credentials);
        return authInfo;
    }
}

