/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.pin.impl;

import com.day.cq.auth.pin.Pin;
import com.day.cq.auth.pin.PinUse;
import com.day.cq.auth.pin.impl.PinUseImpl;
import com.day.cq.auth.pin.impl.PinUsesIterator;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinImpl
implements Pin {
    static final String PROP_PIN = "pin";
    static final String PROP_OWNER = "owner";
    static final String PROP_ENABLED = "enabled";
    static final String PROP_USE_COUNTER = "useCounter";
    static final String PROP_EXPIRY_TIME = "expiry";
    static final String PROP_MAX_USE = "maxUse";
    private final Resource resource;
    private final String id;
    private final String userId;
    private boolean enabled;
    private int useCounter;
    private long expiryTime;
    private int maxUse;

    PinImpl(Resource pinResource) {
        ValueMap props = (ValueMap)pinResource.adaptTo(ValueMap.class);
        if (props == null) {
            throw new IllegalArgumentException("Cannot load PIN from " + pinResource + ": missing properties");
        }
        this.resource = pinResource;
        this.id = (String)props.get(PROP_PIN, String.class);
        this.userId = (String)props.get(PROP_OWNER, String.class);
        this.enabled = (Boolean)props.get(PROP_ENABLED, (Object)false);
        this.useCounter = (Integer)props.get(PROP_USE_COUNTER, (Object)0);
        this.expiryTime = (Long)props.get(PROP_EXPIRY_TIME, (Object)-1L);
        this.maxUse = (Integer)props.get(PROP_MAX_USE, (Object)-1);
    }

    Resource getResource() {
        return this.resource;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getUseCounter() {
        return this.useCounter;
    }

    @Override
    public int getMaxUse() {
        return this.maxUse;
    }

    @Override
    public long getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public Iterator<PinUse> getUses() {
        return new PinUsesIterator(this.resource);
    }

    synchronized boolean isValid(HttpServletRequest request) {
        boolean valid = this.enabled;
        valid &= this.expiryTime < 0L || this.expiryTime > System.currentTimeMillis();
        this.touch(request, valid &= this.maxUse < 0 || this.useCounter <= this.maxUse);
        return valid;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.update(PROP_ENABLED, enabled)) {
            this.enabled = enabled;
        }
    }

    @Override
    public void setAge(int age) {
        this.setExpiryTime(PinImpl.ageToExpiry(age));
    }

    @Override
    public void setExpiryTime(long expiryTime) {
        if (this.update(PROP_EXPIRY_TIME, expiryTime)) {
            this.expiryTime = expiryTime;
        }
    }

    @Override
    public void setMaxUse(int maxUse) {
        if (this.update(PROP_MAX_USE, maxUse)) {
            this.maxUse = maxUse;
        }
    }

    public String toString() {
        return "Pin: " + this.getId() + " (" + this.getUserId() + ")";
    }

    private void touch(HttpServletRequest request, boolean granted) {
        int counter = this.useCounter + 1;
        if (this.update(PROP_USE_COUNTER, counter)) {
            this.useCounter = counter;
        }
        PinUseImpl.storeUse(this.resource, request, granted, counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Type> boolean update(String property, Type value) {
        PersistableValueMap props = (PersistableValueMap)this.resource.adaptTo(PersistableValueMap.class);
        props.put((Object)property, value);
        ResourceResolver resourceResolver = this.resource.getResourceResolver();
        synchronized (resourceResolver) {
            try {
                props.save();
                return true;
            }
            catch (PersistenceException pe) {
                props.reset();
            }
        }
        return false;
    }

    static long ageToExpiry(int age) {
        if (age < 0) {
            return -1L;
        }
        return System.currentTimeMillis() + 1000L * (long)age;
    }
}

