/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.pin.impl;

import com.day.cq.auth.pin.Pin;
import com.day.cq.auth.pin.PinManager;
import com.day.cq.auth.pin.PinManagerFactory;
import com.day.cq.auth.pin.impl.PinAuthenticationHandler;
import com.day.cq.auth.pin.impl.PinCache;
import com.day.cq.auth.pin.impl.PinImpl;
import com.day.cq.auth.pin.impl.PinManagerImpl;
import com.day.cq.auth.pin.impl.PinServlet;
import com.day.cq.auth.pin.impl.PinWebConsolePlugin;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.UUID;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinManagerFactoryImpl
implements PinManagerFactory,
AdapterFactory {
    private static final String PROP_PIN_CACHE_SIZE = "pin.manager.cache.size";
    private static final int DEFAULT_PIN_CACHE_SIZE = 20;
    private static final String PROP_PIN_DEFAULT_AGE = "pin.default.age";
    private static final int DEFAULT_PIN_DEFAULT_AGE = 86400;
    private static final String PROP_PIN_DEFAULT_MAX_USES = "pin.default.maxuse";
    private static final int DEFAULT_PIN_DEFAULT_MAX_USES = -1;
    private static final String PROP_PIN_ADMINISTRATOR = "pin.administrator";
    private static final String DEFAULT_PIN_ADMINISTRATOR = "administrators";
    private static final String NODE_PINS = "pins";
    private static final String TYPE_SLING_FOLDER = "sling:Folder";
    private static final String TYPE_NT_UNSTRUCTURED = "nt:unstructured";
    private static final String TYPE_SLING_RESOURCE = "sling:Resource";
    private static final String TYPE_SLING_HIERARCHY_NODE = "sling:HierarchyNode";
    static final String RESOURCE_TYPE_PIN_FOLDER = "pins/folder";
    static final String RESOURCE_TYPE_PIN = "pins/pin";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SlingRepository repository;
    private JcrResourceResolverFactory resourceResolverFactory;
    private String administrator;
    private Session adminSession;
    private ResourceResolver resolver;
    private PinAuthenticationHandler pinAuthHandler;
    private PinServlet pinServlet;
    private PinWebConsolePlugin pinConsolePlugin;
    private PinCache pinCache;
    private int defaultPinMaxAge;
    private int defaultPinMaxUse;

    @Override
    public PinManager getPinManager(ResourceResolver resourceResolver) {
        if (resourceResolver == null) {
            throw new NullPointerException("resourceResolver");
        }
        return new PinManagerImpl(this, resourceResolver);
    }

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Resource res;
        if (adaptable instanceof ResourceResolver && type == PinManager.class) {
            return (AdapterType)this.getPinManager((ResourceResolver)adaptable);
        }
        if (adaptable instanceof Resource && type == Pin.class && RESOURCE_TYPE_PIN.equals((res = (Resource)adaptable).getResourceType())) {
            String pinId = ResourceUtil.getName((Resource)res);
            return (AdapterType)this.getPin(res.getResourceResolver(), pinId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pin createPin(ResourceResolver resourceResolver, String userId) {
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (!this.isPinAdministratorOrOwner(resourceResolver, userId)) {
            return null;
        }
        String userHome = this.getUserHome(userId);
        if (userHome == null) {
            this.log.error("createPin: Missing home for {}, not creating PIN", (Object)userId);
            return null;
        }
        String pinId = this.createPinId();
        String pinPath = this.createPinResource(userHome, pinId, userId);
        if (pinPath == null) {
            this.log.error("createPin: Unable to create PIN resource for {} in {}, not creating PIN", (Object)userId, (Object)userHome);
            return null;
        }
        Resource pinResource = this.getResourceResolver().getResource(pinPath);
        if (pinResource == null) {
            this.log.error("createPin: Cannot access PIN resource at {} after creation", (Object)pinPath);
        }
        PinImpl pin = new PinImpl(pinResource);
        PinCache pinCache = this.pinCache;
        synchronized (pinCache) {
            this.pinCache.put(pinId, pin);
        }
        return pin;
    }

    Pin getPin(ResourceResolver resourceResolver, String pinId) {
        if (pinId == null) {
            throw new NullPointerException("pinId");
        }
        Pin pin = this.getPinPrivileged(pinId);
        if (pin != null && this.isPinAdministratorOrOwner(resourceResolver, pin.getUserId())) {
            return pin;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pin getPinPrivileged(String pinId) {
        Pin pin;
        PinCache pinCache = this.pinCache;
        synchronized (pinCache) {
            pin = (Pin)this.pinCache.get(pinId);
        }
        if (pin == null && (pin = this.findPin(pinId)) != null) {
            pinCache = this.pinCache;
            synchronized (pinCache) {
                this.pinCache.put(pinId, pin);
            }
        }
        return pin;
    }

    Iterator<Pin> listPins(ResourceResolver resourceResolver, final String userId) {
        if (userId == null ? !this.isPinAdministrator(resourceResolver) : !this.isPinAdministratorOrOwner(resourceResolver, userId)) {
            return Collections.emptyList().iterator();
        }
        return new Iterator<Pin>(){
            final Iterator<Resource> pinResources;
            {
                this.pinResources = PinManagerFactoryImpl.this.findPins(userId);
            }

            @Override
            public boolean hasNext() {
                return this.pinResources.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Pin next() {
                PinImpl pin = new PinImpl(this.pinResources.next());
                PinCache pinCache = PinManagerFactoryImpl.this.pinCache;
                synchronized (pinCache) {
                    Pin cachedPin = (Pin)PinManagerFactoryImpl.this.pinCache.get(pin.getId());
                    if (cachedPin != null) {
                        return cachedPin;
                    }
                    PinManagerFactoryImpl.this.pinCache.put(pin.getId(), pin);
                }
                return pin;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deletePin(ResourceResolver resourceResolver, String pinId) {
        if (pinId == null) {
            throw new NullPointerException("pinId");
        }
        Pin pin = this.getPin(resourceResolver, pinId);
        if (pin != null) {
            this.deletePinResource(pin);
            PinCache pinCache = this.pinCache;
            synchronized (pinCache) {
                this.pinCache.remove(pin.getId());
            }
            return true;
        }
        return false;
    }

    protected void activate(ComponentContext context) {
        BundleContext bundleContext = context.getBundleContext();
        Dictionary properties = context.getProperties();
        int pinCacheLimit = OsgiUtil.toInteger(properties.get(PROP_PIN_CACHE_SIZE), (int)20);
        this.pinCache = new PinCache(pinCacheLimit);
        this.defaultPinMaxAge = OsgiUtil.toInteger(properties.get(PROP_PIN_DEFAULT_AGE), (int)86400);
        this.defaultPinMaxUse = OsgiUtil.toInteger(properties.get(PROP_PIN_DEFAULT_MAX_USES), (int)-1);
        this.administrator = OsgiUtil.toString(properties.get(PROP_PIN_ADMINISTRATOR), (String)DEFAULT_PIN_ADMINISTRATOR);
        this.pinAuthHandler = new PinAuthenticationHandler(bundleContext, this, properties);
        this.pinServlet = new PinServlet(bundleContext, properties);
        this.pinConsolePlugin = new PinWebConsolePlugin(bundleContext, this, properties);
        this.log.warn("PIN Authentication has been deprecated for security reasons.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate() {
        try {
            if (this.pinAuthHandler != null) {
                this.pinAuthHandler.dispose();
                this.pinAuthHandler = null;
            }
            if (this.pinServlet != null) {
                this.pinServlet.dispose();
                this.pinServlet = null;
            }
            if (this.pinConsolePlugin != null) {
                this.pinConsolePlugin.dispose();
                this.pinConsolePlugin = null;
            }
            this.pinCache.clear();
        }
        finally {
            if (this.adminSession != null && this.adminSession.isLive()) {
                this.adminSession.logout();
            }
        }
    }

    private boolean isPinAdministratorOrOwner(ResourceResolver resolver, String userId) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            return false;
        }
        if (userId.equals(session.getUserID())) {
            return true;
        }
        return this.isPinAdministrator(resolver);
    }

    private boolean isPinAdministrator(ResourceResolver resolver) {
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        if (userManager == null) {
            this.log.debug("UserManager not available: Cannot determine identity of pin administrator.");
            return false;
        }
        User user = (User)resolver.adaptTo(User.class);
        try {
            Authorizable pinAdmin = userManager.getAuthorizable(this.administrator);
            if (user != null && pinAdmin != null) {
                if (pinAdmin.isGroup()) {
                    return ((Group)pinAdmin).isMember((Authorizable)user);
                }
                return pinAdmin.getID().equals(user.getID());
            }
        }
        catch (RepositoryException e) {
            this.log.debug("Cannot retrieve pin administrator user/group.", (Object)e.getMessage());
        }
        return false;
    }

    private synchronized Session getAdminSession() {
        if (this.adminSession == null) {
            try {
                this.adminSession = this.repository.loginAdministrative(null);
            }
            catch (RepositoryException e) {
                this.log.error("Cannot create admin session", (Object)e.getMessage());
            }
        }
        return this.adminSession;
    }

    private synchronized ResourceResolver getResourceResolver() {
        Session adminSession;
        if (this.resolver == null && (adminSession = this.getAdminSession()) != null) {
            this.resolver = this.resourceResolverFactory.getResourceResolver(adminSession);
        }
        return this.resolver;
    }

    private synchronized UserManager getUserManager() {
        Session adminSession = this.getAdminSession();
        if (adminSession != null && adminSession instanceof JackrabbitSession) {
            try {
                return ((JackrabbitSession)adminSession).getUserManager();
            }
            catch (RepositoryException e) {
                this.log.error("Error while retrieve user manager", (Object)e.getMessage());
            }
        }
        return null;
    }

    private String createPinId() {
        return UUID.randomUUID().toString();
    }

    private String getUserHome(String userId) {
        block5: {
            UserManager userManager = this.getUserManager();
            if (userManager != null) {
                try {
                    Authorizable user = userManager.getAuthorizable(userId);
                    if (!user.isGroup()) {
                        String homePath = user.getPath();
                        break block5;
                    }
                    this.log.debug("getUserHome: Authorizable {} is not a User", (Object)userId);
                }
                catch (RepositoryException e) {
                    this.log.error("Failed to retrieve user home path.", (Throwable)e);
                }
            } else {
                this.log.debug("getUserHome: Cannot find User {}: UserManager is not accessible", (Object)userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createPinResource(String userHome, String pinId, String userId) {
        Session session = null;
        try {
            session = this.repository.loginAdministrative(null);
            if (!session.nodeExists(userHome)) {
                this.log.error("createPinResource: User {}'s home {} node does not exist", (Object)userId, (Object)userHome);
                String string = null;
                return string;
            }
            Node homeNode = session.getNode(userHome);
            Node pins = PinManagerFactoryImpl.getOrCreateChild(homeNode, NODE_PINS);
            if (pins.isNew()) {
                this.log.debug("createPinResource: Setting resourceType and saving new {} node", (Object)NODE_PINS);
                pins.setProperty("sling:resourceType", RESOURCE_TYPE_PIN_FOLDER);
                session.save();
            }
            Node pinNode = pins.addNode(pinId, TYPE_NT_UNSTRUCTURED);
            pinNode.addMixin(TYPE_SLING_HIERARCHY_NODE);
            pinNode.addMixin(TYPE_SLING_RESOURCE);
            pinNode.setProperty("sling:resourceType", RESOURCE_TYPE_PIN);
            pinNode.setProperty("pin", pinId);
            pinNode.setProperty("owner", userId);
            pinNode.setProperty("expiry", PinImpl.ageToExpiry(this.defaultPinMaxAge));
            pinNode.setProperty("maxUse", (long)this.defaultPinMaxUse);
            pinNode.addNode("uses", TYPE_SLING_FOLDER);
            String pinPath = pinNode.getPath();
            session.save();
            String string = pinPath;
            return string;
        }
        catch (RepositoryException re) {
            this.log.error("createPinResource: Failed creating the PIN Resource in User " + userId + "'s home " + userHome, (Throwable)re);
            String string = null;
            return string;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    static Node getOrCreateChild(Node parent, String name) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, TYPE_SLING_FOLDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePinResource(Pin pin) {
        if (pin instanceof PinImpl) {
            Resource resource = ((PinImpl)pin).getResource();
            Session session = null;
            try {
                session = this.repository.loginAdministrative(null);
                if (session.itemExists(resource.getPath())) {
                    Item item = session.getItem(resource.getPath());
                    item.remove();
                    session.save();
                }
            }
            catch (RepositoryException re) {
                this.log.error("createPinResource: Failed creating the PIN Resource in User ", (Throwable)re);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    private Iterator<Resource> findPins(String owner) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ").append("pin");
        buf.append(" FROM nt:base");
        buf.append(" WHERE sling:resourceType = '").append(RESOURCE_TYPE_PIN).append('\'');
        if (owner != null) {
            buf.append(" AND ");
            buf.append("owner").append(" = '").append(owner).append('\'');
        }
        return this.getResourceResolver().findResources(buf.toString(), "sql");
    }

    private Pin findPin(String pinId) {
        Iterator ri = this.getResourceResolver().findResources("SELECT pin FROM nt:base WHERE sling:resourceType = 'pins/pin' AND pin = '" + pinId + "'", "sql");
        if (ri.hasNext()) {
            Resource pinResource = (Resource)ri.next();
            return new PinImpl(pinResource);
        }
        return null;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resourceResolverFactory == jcrResourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

