/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.pin.impl;

import com.day.cq.auth.pin.Pin;
import com.day.cq.auth.pin.PinManager;
import com.day.cq.auth.pin.PinUse;
import com.day.cq.auth.pin.impl.PinImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_DELETE = "delete";
    private static final String PARAM_MAX_AGE = "maxAge";
    private static final String PARAM_OWNER = "owner";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_MAX_USE = "maxUse";
    private static final String PARAM_EXPIRY = "expiry";
    private static final String HEADER_PIN = "X-CQ-PIN";
    static final String PROP_PIN_SERVLET_PATH = "pin.servlet.path";
    static final String DEFAULT_PIN_SERVLET_PATH = "/libs/cq/security/content/pin";
    private static final int OP_UNSUPPORTED = -1;
    private static final int OP_GET = 0;
    private static final int OP_POST = 1;
    private static final int OP_DELETE = 2;
    private final String servletPath;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceRegistration registration;

    PinServlet(BundleContext bundleContext, Dictionary<?, ?> config) {
        this.servletPath = OsgiUtil.toString(config.get(PROP_PIN_SERVLET_PATH), (String)DEFAULT_PIN_SERVLET_PATH);
        Properties props = new Properties();
        props.put("service.description", "Communique PIN Manager Servlet");
        props.put("service.vendor", config.get("service.vendor"));
        props.put("sling.servlet.paths", this.servletPath);
        props.put("sling.servlet.resourceTypes", new String[]{"pins/pin", "pins/folder"});
        props.put("sling.servlet.methods", new String[]{"GET", "POST", "DELETE"});
        props.put("sling.servlet.prefix", "-1");
        this.registration = bundleContext.registerService(Servlet.class.getName(), (Object)this, (Dictionary)props);
    }

    void dispose() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    protected void service(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        if (request.getAuthType() == null) {
            response.sendError(404);
            return;
        }
        int op = this.getOp((HttpServletRequest)request);
        if (op == -1) {
            this.handleMethodNotImplemented(request, response);
            return;
        }
        Resource resource = request.getResource();
        Pin pin = (Pin)resource.adaptTo(Pin.class);
        if (pin != null) {
            this.managePin(op, pin, request, response);
            return;
        }
        try {
            Resource ownerHome;
            User owner;
            if (resource.getPath().equals(this.servletPath)) {
                String id = this.getId(request);
                if (id == null) {
                    this.managePinFolder(op, null, request, response);
                    return;
                }
                Pin pinById = this.getPin(id, request, (HttpServletResponse)response);
                if (pinById != null) {
                    this.managePin(op, pinById, request, response);
                    return;
                }
                UserManager umgr = (UserManager)request.getResourceResolver().adaptTo(UserManager.class);
                Authorizable user = umgr.getAuthorizable(id);
                if (user != null && !user.isGroup()) {
                    this.managePinFolder(op, user.getID(), request, response);
                    return;
                }
            }
            if (resource.getResourceType().equals("pins/folder") && (owner = (User)(ownerHome = ResourceUtil.getParent((Resource)resource)).adaptTo(User.class)) != null) {
                this.managePinFolder(op, owner.getID(), request, response);
                return;
            }
        }
        catch (RepositoryException e) {
            response.sendError(404);
        }
        response.sendError(404);
    }

    private void managePin(int op, Pin pin, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        switch (op) {
            case 0: {
                this.renderPinDetails(response, pin);
                break;
            }
            case 1: {
                this.updatePin(pin, request, response);
                break;
            }
            case 2: {
                this.deletePin(pin, request, (HttpServletResponse)response);
                break;
            }
            default: {
                this.handleMethodNotImplemented(request, response);
            }
        }
    }

    private void managePinFolder(int op, String owner, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        PinManager pinManager = this.getPinManager(request, (HttpServletResponse)response);
        if (pinManager != null) {
            switch (op) {
                case 0: {
                    this.listPins(response, pinManager.listPins(owner));
                    break;
                }
                case 1: {
                    String pinOwner = owner == null ? this.getOwnerId(request) : owner;
                    Pin pin = pinManager.createPin(pinOwner);
                    if (pin != null) {
                        this.updatePin(pin, request, response);
                        break;
                    }
                    response.sendError(500, "Cannot create PIN for " + pinOwner);
                    break;
                }
                default: {
                    this.handleMethodNotImplemented(request, response);
                }
            }
        }
    }

    private int getOp(HttpServletRequest request) {
        String methodName = request.getMethod();
        if ("GET".equals(methodName)) {
            return 0;
        }
        if ("POST".equals(methodName)) {
            return request.getParameter(PARAM_DELETE) == null ? 1 : 2;
        }
        if ("DELETE".equals(methodName)) {
            return 2;
        }
        return -1;
    }

    private void updatePin(Pin pin, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        String enabled;
        long expiry = this.getParameter((HttpServletRequest)request, PARAM_EXPIRY, Long.MIN_VALUE);
        if (expiry != Long.MIN_VALUE) {
            pin.setExpiryTime(expiry);
        } else {
            int age = this.getParameter((HttpServletRequest)request, PARAM_MAX_AGE, Integer.MIN_VALUE);
            if (age != Integer.MIN_VALUE) {
                pin.setExpiryTime(PinImpl.ageToExpiry(age));
            }
        }
        int maxUse = this.getParameter((HttpServletRequest)request, PARAM_MAX_USE, Integer.MIN_VALUE);
        if (maxUse != Integer.MIN_VALUE) {
            pin.setMaxUse(maxUse);
        }
        if ((enabled = request.getParameter(PARAM_ENABLED)) != null) {
            pin.setEnabled(Boolean.parseBoolean(enabled));
        }
        SlingHttpServletRequestWrapper getRequest = new SlingHttpServletRequestWrapper(request){

            public String getMethod() {
                return "GET";
            }
        };
        RequestDispatcher rd = request.getRequestDispatcher(((PinImpl)pin).getResource());
        rd.forward((ServletRequest)getRequest, (ServletResponse)response);
    }

    private void deletePin(Pin pin, SlingHttpServletRequest request, HttpServletResponse response) throws IOException {
        String pinId = pin.getId();
        PinManager pinManager = this.getPinManager(request, response);
        if (pinManager != null) {
            if (pinManager.deletePin(pinId)) {
                this.log.info("PinServlet.{}: PIN {} deleted", (Object)request.getMethod(), (Object)pinId);
                response.setStatus(200);
                response.setContentType("text/plain");
                response.setCharacterEncoding("UTF-8");
                response.getWriter().println("PIN " + pinId + " deleted");
                return;
            }
            this.log.warn("PinServlet.{}: PIN {} cannot be deleted", (Object)request.getMethod(), (Object)pinId);
        }
        response.sendError(403, "PIN " + pinId + " not deleted");
    }

    private void listPins(SlingHttpServletResponse response, Iterator<Pin> pins) throws IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        if (pins.hasNext()) {
            pw.printf("%-36s  %-12s  %-5s  %-8s %-19s  %-5s\r\n", "Pin ID", "Owner", "Uses", "Enabled", "Expiry Time", "Max Uses");
            while (pins.hasNext()) {
                Pin pin = pins.next();
                pw.printf("%-36s  %-12s  %-5d  %-8s %5$tF %5$tT  %6$-5d\r\n", pin.getId(), pin.getUserId(), pin.getUseCounter(), pin.isEnabled() ? PARAM_ENABLED : "disabled", pin.getExpiryTime(), pin.getMaxUse());
            }
        } else {
            pw.println("No PINs defined");
        }
    }

    private void renderPinDetails(SlingHttpServletResponse response, Pin pin) throws IOException {
        response.setHeader(HEADER_PIN, pin.getId());
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        pw.println("Pin " + pin.getId());
        pw.println();
        pw.println("Owner     : " + pin.getUserId());
        pw.println("# Uses    : " + pin.getUseCounter());
        pw.println("Enabled   : " + pin.isEnabled());
        pw.println("Expires   : " + new Date(pin.getExpiryTime()));
        pw.println("Max #Uses : " + pin.getMaxUse());
        Iterator<PinUse> pinUses = pin.getUses();
        if (pinUses.hasNext()) {
            pw.println();
            pw.println("Uses");
            while (pinUses.hasNext()) {
                PinUse use = pinUses.next();
                String grantType = use.granted() ? "granted" : "denied";
                pw.printf("%1$tF %1$tT %2$-7s %3$s %4$s from %5$s (%6$s)\r\n", use.getTime(), grantType, use.getRequestMethod(), use.getRequestURI(), use.getRemoteHost(), use.getUserAgent());
            }
        }
    }

    private Pin getPin(String pinId, SlingHttpServletRequest request, HttpServletResponse response) throws IOException {
        PinManager pinManager = this.getPinManager(request, response);
        if (pinManager != null) {
            return pinManager.getPin(pinId);
        }
        return null;
    }

    private String getId(SlingHttpServletRequest request) {
        String pinId = request.getRequestPathInfo().getSuffix();
        if (pinId != null && pinId.length() > 1) {
            return pinId.substring(1);
        }
        return null;
    }

    private PinManager getPinManager(SlingHttpServletRequest request, HttpServletResponse response) throws IOException {
        PinManager pinManager = (PinManager)request.getResourceResolver().adaptTo(PinManager.class);
        if (pinManager == null) {
            this.log.error("PinServlet.{}: PinManager not available", (Object)request.getMethod());
            response.sendError(500, "Cannot access PinManager");
            return null;
        }
        return pinManager;
    }

    private String getOwnerId(SlingHttpServletRequest request) {
        String userId = request.getParameter(PARAM_OWNER);
        if (userId != null && userId.length() > 0) {
            return userId;
        }
        return request.getRemoteUser();
    }

    private <Type extends Number> Type getParameter(HttpServletRequest request, String parameterName, Type defaultValue) {
        String value = request.getParameter(parameterName);
        if (value != null) {
            Class<?> targetClass = defaultValue.getClass();
            try {
                if (targetClass == Integer.class) {
                    return (Type)Integer.valueOf(value);
                }
                if (targetClass == Long.class) {
                    return (Type)Long.valueOf(value);
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warn("getIntParameter: Parameter {}={} cannot be converted to {}, using default {}", new Object[]{parameterName, value, targetClass, defaultValue});
            }
        }
        return defaultValue;
    }
}

