/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.pin.impl;

import com.day.cq.auth.pin.PinUse;
import com.day.cq.auth.pin.impl.PinManagerFactoryImpl;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class PinUseImpl
implements PinUse {
    static final String PROP_TIME = "time";
    static final String PROP_METHOD = "method";
    static final String PROP_URI = "uri";
    static final String PROP_GRANTED = "granted";
    static final String PROP_REMOTE = "remote";
    static final String PROP_USER_AGENT = "userAgent";
    static final String CHILD_USES = "uses";
    private final ValueMap props;

    PinUseImpl(Resource pinUse) {
        this.props = ResourceUtil.getValueMap((Resource)pinUse);
    }

    public String getRemoteHost() {
        return (String)this.props.get(PROP_REMOTE, String.class);
    }

    public String getRequestMethod() {
        return (String)this.props.get(PROP_METHOD, String.class);
    }

    public String getRequestURI() {
        return (String)this.props.get(PROP_URI, String.class);
    }

    public long getTime() {
        return (Long)this.props.get(PROP_TIME, (Object)-1L);
    }

    public String getUserAgent() {
        return (String)this.props.get(PROP_USER_AGENT, String.class);
    }

    public boolean granted() {
        return (Boolean)this.props.get(PROP_GRANTED, (Object)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeUse(Resource pinResource, HttpServletRequest request, boolean granted, int counter) {
        Resource usesResource = pinResource.getResourceResolver().getResource(pinResource, CHILD_USES);
        Node usesNode = (Node)usesResource.adaptTo(Node.class);
        if (usesNode != null) {
            ResourceResolver resourceResolver = pinResource.getResourceResolver();
            synchronized (resourceResolver) {
                Session session = null;
                try {
                    session = usesNode.getSession();
                    long time = System.currentTimeMillis();
                    String yearMonth = String.format("%1$tY%1$tm", time);
                    Node monthNode = PinManagerFactoryImpl.getOrCreateChild(usesNode, yearMonth);
                    String day = String.format("%td", time);
                    Node dayNode = PinManagerFactoryImpl.getOrCreateChild(monthNode, day);
                    String use = String.format("%05d", counter);
                    Node useNode = PinManagerFactoryImpl.getOrCreateChild(dayNode, use);
                    useNode.setProperty(PROP_TIME, time);
                    useNode.setProperty(PROP_METHOD, request.getMethod());
                    useNode.setProperty(PROP_URI, request.getRequestURI());
                    useNode.setProperty(PROP_GRANTED, granted);
                    useNode.setProperty(PROP_REMOTE, request.getRemoteAddr() + ":" + request.getRemotePort());
                    useNode.setProperty(PROP_USER_AGENT, request.getHeader("User-Agent"));
                    session.save();
                }
                catch (RepositoryException re) {
                }
                finally {
                    try {
                        if (session.hasPendingChanges()) {
                            session.refresh(false);
                        }
                    }
                    catch (RepositoryException re) {}
                }
            }
        }
    }
}

