/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.auth.pin.impl;

import com.day.cq.auth.pin.PinUse;
import com.day.cq.auth.pin.impl.PinUseImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinUsesIterator
implements Iterator<PinUse> {
    private final ResourceResolver resolver;
    private final Iterator<Resource> yearMonthIterator;
    private Iterator<Resource> dayIterator;
    private Iterator<Resource> useIterator;
    private PinUse nextPinUse;

    PinUsesIterator(Resource pinResource) {
        ResourceResolver resolver = pinResource.getResourceResolver();
        Resource uses = resolver.getResource(pinResource, "uses");
        this.resolver = resolver;
        this.yearMonthIterator = resolver.listChildren(uses);
        this.nextPinUse = this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.nextPinUse != null;
    }

    @Override
    public PinUse next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PinUse pu = this.nextPinUse;
        this.nextPinUse = this.seek();
        return pu;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    private PinUse seek() {
        while (this.useIterator == null || !this.useIterator.hasNext()) {
            while (this.dayIterator == null || !this.dayIterator.hasNext()) {
                if (this.yearMonthIterator.hasNext()) {
                    Resource yearMonth = this.yearMonthIterator.next();
                    this.dayIterator = this.resolver.listChildren(yearMonth);
                    continue;
                }
                return null;
            }
            Resource day = this.dayIterator.next();
            this.useIterator = this.resolver.listChildren(day);
        }
        Resource use = this.useIterator.next();
        return new PinUseImpl(use);
    }
}

