/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.polling.importer;

import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.ComponentContext;

public abstract class HttpImporter
implements Importer {
    private HttpClient httpClient;

    protected abstract void importData(String var1, InputStream var2, String var3, Resource var4) throws IOException;

    public void importData(String scheme, String dataSource, Resource target) {
        HttpMethodBase method = this.newHttpMethod(dataSource);
        InputStream ins = null;
        try {
            int statusCode = this.getHttpClient().executeMethod((HttpMethod)method);
            switch (statusCode) {
                case 200: {
                    break;
                }
                case 304: {
                    return;
                }
                default: {
                    throw new ImportException("Failed retreiving data" + method.getStatusLine());
                }
            }
            ins = method.getResponseBodyAsStream();
            this.importData(scheme, ins, method.getResponseCharSet(), target);
        }
        catch (HttpException e) {
            throw new ImportException("Fatal protocol violation", e);
        }
        catch (IOException e) {
            throw new ImportException("Fatal transport error", e);
        }
        catch (IllegalStateException ise) {
            throw new ImportException("HttpImporter has not been initialized yet", ise);
        }
        catch (Exception e) {
            throw new ImportException("Unexpected problem while importing data", e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ioe) {}
            }
            method.releaseConnection();
        }
    }

    protected final HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        }
        return this.httpClient;
    }

    protected HttpMethodBase newHttpMethod(String source) {
        return new GetMethod(source);
    }

    protected final void init() {
    }

    protected final void destroy() {
        if (this.httpClient != null) {
            HttpConnectionManager cm = this.httpClient.getHttpConnectionManager();
            if (cm instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)cm).shutdown();
            }
            this.httpClient = null;
        }
    }

    protected void activate(ComponentContext context) {
        this.init();
    }

    protected void deactivate(ComponentContext context) {
        this.destroy();
    }
}

