/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.polling.importer.impl;

import com.day.cq.polling.importer.PollConfig;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollConfigImpl
implements PollConfig {
    private static final Logger log = LoggerFactory.getLogger((String)PollConfigImpl.class.getName());
    public static final String PROP_SOURCE = "source";
    public static final String PROP_TARGET = "target";
    public static final String PROP_INTERVAL = "interval";
    public static final long ALLOWED_MINIMUM_INTERVAL = 1L;
    public static final long DEFAULT_INTERVAL = 1800L;
    private static long minimumInterval = 1L;
    private final String path;
    private final String scheme;
    private final String source;
    private final String target;
    private final long interval;
    private ServiceRegistration scheduledTask;

    static void setMinimumInterval(long minimumInterval) {
        if (minimumInterval < 1L) {
            minimumInterval = 1L;
        }
        PollConfigImpl.minimumInterval = minimumInterval;
    }

    static long getMinimumInterval() {
        return minimumInterval;
    }

    static PollConfigImpl create(Resource resource) {
        ValueMap props = (ValueMap)resource.adaptTo(ValueMap.class);
        if (props != null) {
            String source = (String)props.get(PROP_SOURCE, String.class);
            if (source != null) {
                String[] schemeSource = source.split(":", 2);
                if (schemeSource.length < 2) {
                    log.error("create: Illegal Config from {}: source '{}' is incomplete", (Object)resource, (Object)source);
                    return null;
                }
                if (schemeSource[0].length() == 0) {
                    log.error("create: Illegal Config from {}: source '{}' has no scheme", (Object)resource, (Object)source);
                    return null;
                }
                if (schemeSource[1].length() == 0) {
                    log.error("create: Illegal Config from {}: source '{}' has no scheme-specific part", (Object)resource, (Object)source);
                    return null;
                }
                String target = (String)props.get(PROP_TARGET, (Object)resource.getPath());
                long interval = (Long)props.get(PROP_INTERVAL, (Object)1800L);
                if (interval >= 0L) {
                    return new PollConfigImpl(resource.getPath(), schemeSource[0], schemeSource[1], target, interval);
                }
                log.info("create: Ignoring Config from {}: Interval is negatve ({})", (Object)resource, (Object)interval);
            } else {
                log.info("create: Ignoring Config from {}: Source missing", (Object)resource);
            }
        } else {
            log.info("create: Ignoring Config from {}: No properties set", (Object)resource);
        }
        return null;
    }

    private PollConfigImpl(String path, String scheme, String source, String target, long interval) {
        if (interval < minimumInterval) {
            interval = minimumInterval;
        }
        if (target.contains("{}")) {
            target = this.replaceSource(target, source);
        }
        if (!target.startsWith("/")) {
            target = ResourceUtil.normalize((String)(path + "/" + target));
        }
        this.path = path;
        this.scheme = scheme;
        this.source = source;
        this.target = target;
        this.interval = interval;
    }

    public String getPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setScheduledTask(ServiceRegistration scheduledTask) {
        this.scheduledTask = scheduledTask;
    }

    public ServiceRegistration getScheduledTask() {
        return this.scheduledTask;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PollConfig(").append(this.getPath()).append("): ");
        sb.append("scheme=").append(this.getScheme());
        sb.append(",source=").append(this.getSource());
        sb.append(",target=").append(this.getTarget());
        sb.append(",interval=").append(this.getInterval()).append("s");
        return sb.toString();
    }

    private String replaceSource(String target, String source) {
        char[] sourceBuf = new char[source.length()];
        int b = 0;
        boolean lastReplaced = false;
        for (int s = 0; s < source.length(); ++s) {
            char sc = source.charAt(s);
            if (sc < '0' || sc > '9' && sc < 'A' || sc > 'Z' && sc < 'a' || sc > 'z') {
                if (lastReplaced) continue;
                lastReplaced = true;
                sourceBuf[b++] = 95;
                continue;
            }
            lastReplaced = false;
            sourceBuf[b++] = sc;
        }
        source = new String(sourceBuf, 0, b);
        int loc = target.indexOf("{}");
        return target.substring(0, loc) + source + target.substring(loc + 2);
    }
}

