/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.polling.importer.impl;

import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import com.day.cq.polling.importer.PollConfig;
import com.day.cq.polling.importer.PollingImporter;
import com.day.cq.polling.importer.impl.PollConfigImpl;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingImporterImpl
implements PollingImporter,
EventListener {
    private static final String NT_CQ_POLL_CONFIG = "cq:PollConfig";
    private static final String ELEMENT_CQ_POLL_CONFIG = "//element(*,cq:PollConfig)";
    private static final String PROP_MIN_INTERVAL = "importer.min.interval";
    private static final long DEFAULT_MIN_INTERVAL = 300L;
    private static final String IMPORTER_REF_NAME = "importer";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<String, Importer> importers = new HashMap<String, Importer>();
    private SlingRepository repository;
    private JcrResourceResolverFactory resourceResolverFactory;
    private Set<ServiceReference> delayedImporters = new HashSet<ServiceReference>();
    private ComponentContext context;
    private ResourceResolver resolver;
    private Map<String, PollConfig> pollConfigs = new HashMap<String, PollConfig>();

    public void onEvent(EventIterator events) {
        HashSet<String> modifiedEntries = new HashSet<String>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            try {
                String path = event.getPath();
                path = ResourceUtil.getParent((String)path);
                modifiedEntries.add(path);
            }
            catch (RepositoryException re) {
                this.log.warn("onEvent: Cannot get path of event " + event, (Throwable)re);
            }
        }
        for (String modifiedEntry : modifiedEntries) {
            this.removeResource(modifiedEntry);
            this.addResource(modifiedEntry);
        }
    }

    @Override
    public Iterator<PollConfig> getPollConfigs() {
        return this.pollConfigs.values().iterator();
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        long minInterval = OsgiUtil.toLong(props.get(PROP_MIN_INTERVAL), (long)300L);
        PollConfigImpl.setMinimumInterval(minInterval);
        this.context = context;
        for (ServiceReference serviceReference : this.delayedImporters) {
            this.bindImporter(serviceReference);
        }
        this.delayedImporters.clear();
        this.setupInitialConfiguration();
    }

    protected void deactivate(ComponentContext context) {
        String[] resourcePaths;
        this.ungetSession();
        this.context = null;
        for (String resourcePath : resourcePaths = this.pollConfigs.keySet().toArray(new String[this.pollConfigs.size()])) {
            this.removeResource(resourcePath);
        }
    }

    protected void bindImporter(ServiceReference ref) {
        ComponentContext context = this.context;
        if (context != null) {
            String[] schemes = OsgiUtil.toStringArray((Object)ref.getProperty("importer.scheme"));
            if (schemes != null && schemes.length != 0) {
                Importer importer = (Importer)context.locateService(IMPORTER_REF_NAME, ref);
                for (String scheme : schemes) {
                    Importer registeredImporter = this.importers.get(scheme);
                    if (registeredImporter == null) {
                        this.log.info("bindImporter: Registering scheme {} ({})", (Object)scheme, (Object)importer);
                        this.importers.put(scheme, importer);
                        continue;
                    }
                    this.log.warn("bindImporter: Scheme {} already registered by importer {}", (Object)scheme, (Object)registeredImporter);
                }
            }
        } else {
            this.delayedImporters.add(ref);
        }
    }

    protected void unbindImporter(ServiceReference ref) {
        String[] schemes = OsgiUtil.toStringArray((Object)ref.getProperty("importer.scheme"));
        if (schemes != null && schemes.length > 0) {
            for (String scheme : schemes) {
                this.log.info("unbindImporter: Unregistering scheme {}", (Object)scheme);
                this.importers.remove(scheme);
            }
        }
        this.delayedImporters.remove(ref);
    }

    protected void bindRepository(SlingRepository repository) {
        this.repository = repository;
        this.ungetSession();
    }

    protected void unbindRepository(SlingRepository repository) {
        if (this.repository == repository) {
            this.ungetSession();
            this.repository = null;
        }
    }

    private void addResource(String resourcePath) {
        try {
            Resource res = this.getSession().getResource(resourcePath);
            if (res != null) {
                this.addResource(res);
            }
        }
        catch (RepositoryException re) {
            this.log.error("addResource: Cannot get ResourceResolver to add resource " + resourcePath, (Throwable)re);
        }
    }

    private void addResource(Resource resource) {
        final PollConfigImpl pc = PollConfigImpl.create(resource);
        if (pc != null) {
            this.pollConfigs.put(resource.getPath(), pc);
            this.log.info("addResource: Registering PollConfig {}", (Object)pc);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("scheduler.period", pc.getInterval());
            ((Dictionary)props).put("scheduler.concurrent", false);
            ((Dictionary)props).put("scheduler.name", pc.getSource());
            ((Dictionary)props).put("service.description", pc.toString());
            ((Dictionary)props).put("service.vendor", "Day Management AG");
            Runnable task = new Runnable(){
                final PollConfig pollConfig;
                {
                    this.pollConfig = pc;
                }

                public void run() {
                    PollingImporterImpl.this.importData(this.pollConfig);
                }
            };
            pc.setScheduledTask(this.context.getBundleContext().registerService(Runnable.class.getName(), (Object)task, props));
        } else {
            this.log.debug("addResource: Resource {} is not a PollConfig or polling of this config is disabled, ignoring", (Object)resource);
        }
    }

    private void removeResource(String resourcePath) {
        PollConfig pc = this.pollConfigs.remove(resourcePath);
        if (pc instanceof PollConfigImpl) {
            this.log.info("removeResource: Unregistering PollConfig {}", (Object)pc);
            ServiceRegistration sr = ((PollConfigImpl)pc).getScheduledTask();
            if (sr != null) {
                sr.unregister();
            }
        } else if (pc != null) {
            this.log.info("removeResource: Unregistering generic PollConfig {}", (Object)pc);
        } else {
            this.log.debug("removeResource: No PollConfig at {} to unregister", (Object)resourcePath);
        }
    }

    private void importData(PollConfig pollConfig) {
        Importer importer = this.importers.get(pollConfig.getScheme());
        if (importer != null) {
            try {
                Resource target = this.getSession().getResource(pollConfig.getTarget());
                if (target != null) {
                    this.log.info("importData: Importing data from {}:{} to {} by {}", new Object[]{pollConfig.getScheme(), pollConfig.getSource(), target, importer});
                    importer.importData(pollConfig.getScheme(), pollConfig.getSource(), target);
                }
            }
            catch (RepositoryException re) {
                this.log.warn("importData: Cannot get ResourceResolver for import of " + pollConfig, (Throwable)re);
            }
            catch (ImportException ie) {
                Object cause = ie.getCause();
                if (cause == null) {
                    cause = ie;
                }
                this.log.warn("importData: Failed to import " + pollConfig, cause);
            }
            catch (Exception e) {
                this.log.error("importData: Unexpected failure importing " + pollConfig, (Throwable)e);
            }
        } else {
            this.log.warn("importData: Cannot import from {}: No importer for scheme {} registered", (Object)pollConfig, (Object)pollConfig.getScheme());
        }
    }

    private void setupInitialConfiguration() {
        try {
            final ResourceResolver resolver = this.getSession();
            Thread setupThread = new Thread("Setup Initial Configuration"){

                public void run() {
                    Iterator resources = resolver.findResources(PollingImporterImpl.ELEMENT_CQ_POLL_CONFIG, "xpath");
                    while (resources.hasNext()) {
                        PollingImporterImpl.this.addResource((Resource)resources.next());
                    }
                }
            };
            setupThread.start();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    private ResourceResolver getSession() throws RepositoryException {
        if (this.resolver == null) {
            Session session = this.repository.loginAdministrative(null);
            session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 28, "/", true, null, new String[]{NT_CQ_POLL_CONFIG}, true);
            session.getWorkspace().getObservationManager().addEventListener(new EventListener(){

                public void onEvent(EventIterator events) {
                    while (events.hasNext()) {
                        Event event = events.nextEvent();
                        try {
                            PollingImporterImpl.this.removeResource(event.getPath());
                        }
                        catch (RepositoryException re) {
                            PollingImporterImpl.this.log.error("onEvent: Cannot get path for event " + event, (Throwable)re);
                        }
                    }
                }
            }, 2, "/", true, null, null, true);
            this.resolver = this.resourceResolverFactory.getResourceResolver(session);
        }
        return this.resolver;
    }

    private void ungetSession() {
        if (this.resolver != null) {
            Session session = (Session)this.resolver.adaptTo(Session.class);
            this.resolver = null;
            try {
                session.logout();
            }
            catch (Exception e) {
                this.log.warn("ungetSession: Unexpected failure to logout session !", (Throwable)e);
            }
            Object var1_1 = null;
        }
    }

    protected void bindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resourceResolverFactory == jcrResourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

