/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.audit;

import com.day.cq.audit.AuditLog;
import com.day.cq.audit.AuditLogEntry;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.JobProcessor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ReplicationEventListener
implements EventHandler,
JobProcessor {
    protected AuditLog auditLog;

    public void handleEvent(Event event) {
        if (EventUtil.isLocal((Event)event)) {
            EventUtil.processJob((Event)event, (JobProcessor)this);
        }
    }

    public boolean process(Event event) {
        ReplicationAction re = ReplicationAction.fromEvent(event);
        if (re != null) {
            EventPropertiesMap properties = re.createProperties();
            properties.remove((Object)"modificationDate");
            properties.remove((Object)"path");
            properties.remove((Object)"type");
            properties.remove((Object)"userId");
            AuditLogEntry ae = new AuditLogEntry("com/day/cq/replication", new Date(re.getTime()), re.getUserId(), re.getPath(), re.getType().getName(), (Map)properties);
            AuditLog localAL = this.auditLog;
            if (localAL != null) {
                if (re.getType() == ReplicationActionType.DEACTIVATE) {
                    AuditLogEntry[] existingEntries;
                    ArrayList<AuditLogEntry> entries = new ArrayList<AuditLogEntry>();
                    entries.add(ae);
                    for (AuditLogEntry ale : existingEntries = localAL.getLatestEventsFromTree(new String[]{"com/day/cq/replication"}, re.getPath(), 1)) {
                        if (ale.getPath().equals(re.getPath())) continue;
                        AuditLogEntry updateEntry = new AuditLogEntry("com/day/cq/replication", new Date(re.getTime()), re.getUserId(), ale.getPath(), re.getType().getName(), (Map)properties);
                        entries.add(updateEntry);
                    }
                    localAL.add(entries);
                } else {
                    localAL.add(ae);
                }
            }
        }
        return true;
    }

    protected void bindAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    protected void unbindAuditLog(AuditLog auditLog) {
        if (this.auditLog == auditLog) {
            this.auditLog = null;
        }
    }
}

