/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.content.durbo;

import com.day.durbo.DurboInput;
import com.day.text.ISO9075;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DurboUtil {
    public static final String REP_POLICY_NODE_TYPE = "rep:Policy";
    public static final String REP_POLICY_NODE = "rep:policy";
    public static final String ORDER_SIBLINGS_PROPERTY = "orderSiblings";
    public static final String ORDER_CHILDREN_PROPERTY = "orderChildren";
    public static final String START_PATH_PROPERTY = "startPath";
    public static final String PARENT_NODE_TYPES_PROPERTY = "parentNodeTypes";
    public static final String MIME_TYPE = "application/cq5-replication-durbo";
    public static final Set<String> IGNORED_PROPERTIES = new HashSet<String>();
    public static final Set<String> IGNORED_NODES;
    public static final Set<String> IGNORED_MIXIN_TYPES;

    public static String getValue(Map<String, DurboInput.Property> props, String key, String defaultValue) {
        if (props.containsKey(key)) {
            return props.get(key).getString();
        }
        return defaultValue;
    }

    public static String putNodeNames(Node node) throws RepositoryException {
        StringBuilder listBuffer = new StringBuilder();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            String name = iter.nextNode().getName();
            if (name.startsWith("jcr:")) continue;
            listBuffer.append(ISO9075.encode((String)name)).append(',');
        }
        return listBuffer.toString();
    }

    public static String[] getNodeNames(Map<String, DurboInput.Property> props, String key) {
        String rawValue = DurboUtil.getValue(props, key, null);
        if (rawValue != null) {
            String[] values = rawValue.split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = ISO9075.decode((String)values[i]);
            }
            return values;
        }
        return new String[0];
    }

    static {
        IGNORED_PROPERTIES.add("jcr:primaryType");
        IGNORED_PROPERTIES.add("jcr:mixinTypes");
        IGNORED_PROPERTIES.add("jcr:uuid");
        IGNORED_PROPERTIES.add("jcr:frozenMixinTypes");
        IGNORED_PROPERTIES.add("jcr:frozenPrimaryType");
        IGNORED_PROPERTIES.add("jcr:frozenUuid");
        IGNORED_PROPERTIES.add("jcr:versionHistory");
        IGNORED_PROPERTIES.add("jcr:baseVersion");
        IGNORED_PROPERTIES.add("jcr:predecessors");
        IGNORED_PROPERTIES.add("jcr:successors");
        IGNORED_PROPERTIES.add("jcr:isCheckedOut");
        IGNORED_PROPERTIES.add("cq:distribute");
        IGNORED_NODES = new HashSet<String>();
        IGNORED_NODES.add(REP_POLICY_NODE);
        IGNORED_MIXIN_TYPES = new HashSet<String>();
        IGNORED_MIXIN_TYPES.add("rep:AccessControllable");
    }
}

