/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication.impl;

import com.day.cq.replication.ReplicationContent;
import com.day.cq.replication.ReplicationContentFacade;
import com.day.cq.replication.ReplicationContentFactory;
import com.day.cq.replication.impl.FileContent;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentFactory
implements ReplicationContentFactory {
    private static final Logger log = LoggerFactory.getLogger(FileContentFactory.class);
    private File dataDir;

    public FileContentFactory(File rootDir, String agentId) {
        this.dataDir = new File(rootDir, agentId);
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        log.info("FileContentFactory for {} initialized. Data Directory is: {}", (Object)agentId, (Object)this.dataDir.getAbsolutePath());
    }

    public ReplicationContent create(String mimeType, File file, boolean isTemp) throws IOException {
        return this.create(mimeType, file, file.lastModified(), isTemp);
    }

    public ReplicationContent create(String mimeType, File file, long lastModified, boolean isTemp) throws IOException {
        String name = UUID.randomUUID().toString() + ".ser";
        File dataFile = new File(this.dataDir, name);
        if (isTemp) {
            FileUtils.moveFile((File)file, (File)dataFile);
        } else {
            FileUtils.copyFile((File)file, (File)dataFile);
        }
        dataFile.setLastModified(lastModified);
        log.info("Created file content at {}", (Object)dataFile.getAbsolutePath());
        return new FileContent(dataFile.getAbsolutePath(), mimeType);
    }

    public ReplicationContent create(ReplicationContentFacade facade) {
        if (facade == null) {
            return ReplicationContent.VOID;
        }
        return new FileContent(facade);
    }

    public void close() {
    }
}

